% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_edges.R
\name{get_edges}
\alias{get_edges}
\title{Get node IDs associated with edges}
\usage{
get_edges(x, edge_attr = NULL, match = NULL, return_type = "vector")
}
\arguments{
\item{x}{either a graph object of class
\code{dgr_graph} that is created using
\code{create_graph} or an edge data frame.}

\item{edge_attr}{an optional character vector of
edge attribute values for filtering the edges
returned.}

\item{match}{an option to provide a logical
expression with a comparison operator (\code{>},
\code{<}, \code{==}, or \code{!=}) followed by a
number for numerical filtering, or, a character
string for filtering the edges returned through
string matching.}

\item{return_type}{using \code{vector} (the
default), a vector of character objects
representing the edges is provided. With
\code{list} a list object will be provided that
contains vectors of outgoing and incoming node IDs
associated with edges. With \code{df}, a data frame
containing outgoing and incoming node IDs associated
with edges.}
}
\value{
a list, data frame, or a vector object,
depending on the value given to \code{return_type}.
}
\description{
Obtain a vector, data frame, or list of
node IDs from a graph object or an edge data frame.
An optional filter by edge attribute can limit the
set of edges returned.
}
\examples{
# Create a node data frame (ndf)
nodes <-
  create_nodes(
    nodes = c("a", "b", "c", "d"),
    type = "letter",
    color = c("red", "green", "grey", "blue"),
    value = c(3.5, 2.6, 9.4, 2.7))

# Create an edge data frame (edf)
edges <-
  create_edges(
    from = c("a", "b", "c"),
    to = c("d", "c", "a"),
    rel = "leading_to",
    color = c("pink", "blue", "red"),
    value = c(3.9, 2.5, 7.3))

# Create a graph
graph <-
  create_graph(
    nodes_df = nodes,
    edges_df = edges)

# Get all edges within a graph, returned as a list
get_edges(graph)
#> [[1]]
#> [1] "a" "b" "c"
#>
#> [[2]]
#> [1] "d" "c" "a"

# Get all edges within a graph, returned as a
# data frame
get_edges(graph, return_type = "df")
#>   from to
#> 1    a  d
#> 2    b  c
#> 3    c  a

# Get all edges within a graph, returned as a vector
get_edges(graph, return_type = "vector")
#> [1] "a -> d" "b -> c" "c -> a"

# Get a vector of edges using a numeric
# comparison (i.e., all edges with a `value`
# attribute greater than 3)
get_edges(
  graph,
  edge_attr = "value",
  match = "> 3",
  return_type = "vector")
#> [1] "a -> d" "c -> a"

# Get a vector of edges using a match
get_edges(
  graph,
  edge_attr = "color",
  match = "pink",
  return_type = "vector")
#> [1] "a -> d"
}

