% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_prism.R
\name{add_prism}
\alias{add_prism}
\title{Add a prism of nodes to the graph}
\usage{
add_prism(graph, n, type = NULL, label = TRUE, rel = NULL, nodes = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}

\item{n}{the number of nodes describing the shape
of the prism. For example, the triangonal prism has
\code{n} equal to 3 and it is composed of 6 nodes
and 9 edges. For any n-gonal prism, the graph will
be generated with 2\code{n} nodes and 3\code{n}
edges.}

\item{type}{an optional string that describes the
entity type for the nodes to be added.}

\item{label}{either a vector object of length
\code{n} that provides optional labels for the new
nodes, or, a boolean value where setting to
\code{TRUE} ascribes node IDs to the label and
\code{FALSE} yields a blank label.}

\item{rel}{an optional string for providing a
relationship label to all new edges created in the
node prism.}

\item{nodes}{an optional vector of node IDs of
length \code{n} for the newly created nodes. If
nothing is provided, node IDs will assigned as
monotonically increasing integers.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class
\code{dgr_graph}, add a node prism to the graph.
}
\examples{
library(magrittr)

# Create a new graph and add a prism
graph <-
  create_graph() \%>\%
  add_prism(3, "prism")

# Get node information from this graph
node_info(graph)
#>   node label  type deg indeg outdeg loops
#> 1    1     1 prism   3     1      2     0
#> 2    2     2 prism   3     1      2     0
#> 3    3     3 prism   3     1      2     0
#> 4    4     4 prism   3     2      1     0
#> 5    5     5 prism   3     2      1     0
#> 6    6     6 prism   3     2      1     0
}

