% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_metagraph.R
\name{display_metagraph}
\alias{display_metagraph}
\title{Display a property graph's underlying model}
\usage{
display_metagraph(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}. This graph must fulfill the
condition of being a property graph, otherwise
the function yields an error.}
}
\description{
With a graph object of class
\code{dgr_graph} that is also a property
graph (i.e., all nodes have an assigned
\code{type} value and all edges have an assigned
\code{rel} value), display its metagraph in the
RStudio Viewer. This representation provides all
combinations of edges of different \code{rel}
values to all nodes with distinct \code{type}
values, including any edges to nodes of the same
\code{type} (shown as loops). The precondition
of the graph being a property graph can be
verified by using the \code{is_property_graph()}
function.
}
\examples{
\dontrun{
# Create a randomized property graph with 1000
# nodes and 1350 edges
property_graph <-
  create_random_graph(
    n = 1000, m = 1350,
    set_seed = 23) \%>\%
  select_nodes_by_degree(
    expressions = "deg >= 3") \%>\%
  set_node_attrs_ws(
    node_attr = "type",
    value = "a") \%>\%
  clear_selection() \%>\%
  select_nodes_by_degree(
    expressions = "deg < 3") \%>\%
  set_node_attrs_ws(
    node_attr = "type",
    value = "b") \%>\%
  clear_selection() \%>\%
  select_nodes_by_degree(
    expressions = "deg == 0") \%>\%
  set_node_attrs_ws(
    node_attr = "type",
    value = "c") \%>\%
  set_node_attr_to_display(
    attr = "type") \%>\%
  select_edges_by_node_id(
    nodes =
      get_node_ids(.) \%>\%
      sample(
        size = 0.15 * length(.) \%>\%
          floor())) \%>\%
  set_edge_attrs_ws(
    edge_attr = "rel",
    value = "r_1") \%>\%
  invert_selection() \%>\%
  set_edge_attrs_ws(
    edge_attr = "rel",
    value = "r_2") \%>\%
  clear_selection() \%>\%
  copy_edge_attrs(
    edge_attr_from = "rel",
    edge_attr_to = "label") \%>\%
  add_global_graph_attrs(
    attr = "fontname",
    value = "Helvetica",
    attr_type = "edge") \%>\%
  add_global_graph_attrs(
    attr = "fontcolor",
    value = "gray50",
    attr_type = "edge") \%>\%
  add_global_graph_attrs(
    attr = "fontsize",
    value = 10,
    attr_type = "edge")

# Display this graph's metagraph, or, underlying
# graph model for a property graph
display_metagraph(property_graph)
}
}
