% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_girth.R
\name{get_girth}
\alias{get_girth}
\title{Get graph girth}
\usage{
get_girth(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a single numeric value representing the
length of the shortest circle in the graph.
}
\description{
Get the girth of a graph, which is
the length of the shortest circle in the graph.
Loop edges and multiple edges are not considered.
If the graph contains no cycles then zero is
returned.
}
\examples{
# Create a cycle graph
graph <-
  create_graph() \%>\%
  add_cycle(n = 5)

# Determine the graph's girth
get_girth(graph)
#> [1] 5

# Create a full graph and then
# get the girth for that
create_graph() \%>\%
  add_full_graph(n = 10) \%>\%
  get_girth()
#> [1] 3
}
