% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_unconnected_nodes.R
\name{count_unconnected_nodes}
\alias{count_unconnected_nodes}
\title{Get count of all unconnected nodes}
\usage{
count_unconnected_nodes(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a numeric vector of single length.
}
\description{
From a graph object of class
\code{dgr_graph}, get a count of nodes in the
graph that are not connected to any other node.
}
\examples{
# Create a graph with a
# path of nodes and 3
# unconnected nodes
graph <-
  create_graph() \%>\%
  add_path(n = 3) \%>\%
  add_n_nodes(n = 3)

# Get a count of all nodes
# in the graph
graph \%>\%
  count_nodes()

# Get a count of all
# unconnected nodes in the
# graph
graph \%>\%
  count_unconnected_nodes()
}
