% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_set.R
\name{plot3d_mesh}
\alias{plot3d_mesh}
\title{Plot a three dimensional mesh}
\usage{
plot3d_mesh(mesh, view = "scatterplot3d", color = "black", ...)
}
\arguments{
\item{mesh}{3-dimensional mesh to draw}

\item{view}{3d framework to use: 'rgl' or 'scatterplot3d' (default)}

\item{color}{color of the mesh}

\item{...}{optional arguments passed to plot function}
}
\description{
Plot a three dimensional mesh
}
\examples{
plot2d_mesh(mesh_exsets(f = function(x) sin(pi*x[1])*sin(pi*x[2]),
                        threshold=0,sign=1, mesh="unif",mesh.size=11,
                        intervals = matrix(c(1/2,5/2,1/2,5/2),nrow=2)))

plot3d_mesh(mesh_exsets(function(x) (0.5+x[1])^2+(-0.5+x[2])^2+(0.+x[3])^2,
                        threshold = .25,sign=-1, mesh="unif", mesh.sizes = 10,
                        intervals=matrix(c(-1,1,-1,1,-1,1),nrow=2)))

plot3d_mesh(mesh_exsets(function(x) (0.5+x[1])^2+(-0.5+x[2])^2+(0.+x[3])^2,
                        threshold = .25,sign=-1, mesh="unif", mesh.sizes = 10,
                        intervals=matrix(c(-1,1,-1,1,-1,1),nrow=2)),mode='rgl')
}
