% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funs.R
\name{hist.DiscreteFDR}
\alias{hist.DiscreteFDR}
\title{Histogram of Raw P-Values}
\usage{
\method{hist}{DiscreteFDR}(x, mode = c("raw", "selected"), breaks = "FD", ...)
}
\arguments{
\item{x}{an object of class \code{DiscreteFDR}.}

\item{mode}{single character string specifying for which $p$-values the
histogram is to be generated; must either be \code{"raw"} or
\code{"selected"}.}

\item{breaks}{as in \code{\link[graphics:hist]{graphics::hist()}}; here, the Friedman-Diaconis
algorithm (\code{"FD"}) is used as default.}

\item{...}{further arguments to \code{\link[graphics:hist]{graphics::hist()}} or
\code{\link[graphics:plothistogram]{graphics::plot.histogram()}}, respectively.}
}
\value{
An object of class \code{histogram}.
}
\description{
Computes a histogram of the raw p-values of a \code{DiscreteFDR} object.
}
\details{
If \code{x} does not contain results of a selection approach, a warning is issued
and a histogram of the raw p-values is drawn.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Compute p-values and their supports of Fisher's exact test
test.result <- generate.pvalues(df, "fisher")
raw.pvalues <- test.result$get_pvalues()
pCDFlist <- test.result$get_pvalue_supports()

# DBH (SU)
DBH <- DBH(raw.pvalues, pCDFlist)
hist(DBH)

}
