% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGF_pois.R
\name{MGF_pois}
\alias{MGF_pois}
\title{Moment Generating Function of the Poisson distribution}
\usage{
MGF_pois(t, lambda)
}
\arguments{
\item{t}{t}

\item{lambda}{Rate parameter \eqn{\lambda}{lambda}.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{MGF_pois}}}{ gives the moment generating function (MGF).}
 \item{\code{\link{PGF_pois}}}{ gives the probability generating function (PGF).}
 \item{\code{\link{E_pois}}}{ gives the expected value.}
 \item{\code{\link{V_beta}}}{ gives the variance.}
 \item{\code{\link{Etronq_pois}}}{ gives the truncated mean.}
 \item{\code{\link{TVaR_pois}}}{ gives the Tail Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Moment Generating Function (MGF) of the Poisson
   distribution with rate parameter \eqn{\lambda}{lambda}.
}
\details{
The Poisson distribution with rate parameter \eqn{\lambda}{lam}
  has probability mass function :
  \deqn{Pr(X = k) = \frac{\lambda^k \textrm{e}^{-\lambda}}{k!}}{Pr(X = k) = (lam^k e^(-lam)) / k!}
  for \eqn{k = 0, 1, 2, \dots}{k = 0, 1, 2, ...}, and \eqn{\lambda > 0}{lam > 0}
}
\examples{

MGF_pois(t = 1, lambda = 3)

}
\seealso{
Other Poisson Distribution: 
\code{\link{E_pois}()},
\code{\link{Etronq_pois}()},
\code{\link{PGF_pois}()},
\code{\link{TVaR_pois}()},
\code{\link{V_pois}()}
}
\concept{Poisson Distribution}
