% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/site_regroup.R
\name{site_regroup}
\alias{site_regroup}
\title{Regroup Sites}
\usage{
site_regroup(clusterised_object, regroup_radius = 40075000)
}
\arguments{
\item{clusterised_object}{An object created by the clusterise_sites function.}

\item{regroup_radius}{The specified radius of each group.}
}
\value{
The clusterised object with new group labels.
}
\description{
Takes a set of coordinates and groups them based on a specified radius.
}
\examples{
# regroup the sites with a group radius of 5km instead of 20km
Colombia_Caquetá_dataframe <- subset(Colombia, stateProvince == "Caquetá")

clusterised_Caquetá <- clusterise_sites(dataframe = Colombia_Caquetá_dataframe,
                                       cluster_min_length = 30,
                                       group_radius = 20000
)

print(clusterised_Caquetá[[2]])

clusterised_Caquetá_5km_sites <- site_regroup(

 clusterised_object = clusterised_Caquetá,
 regroup_radius = 5000

)

print(clusterised_Caquetá_5km_sites[[2]])
}
