% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotfunctions.R
\name{responseplot.occu}
\alias{responseplot.occu}
\title{plot the response of an occupancy model to the change of aparticular variable}
\usage{
responseplot.occu(batch, spp, variable)
}
\arguments{
\item{batch}{A result from the batchoccu function.}

\item{spp}{The species number of which response is going to be ploted.}

\item{variable}{The variable of which the response is to be ploted.}
}
\value{
a ggplot object plotting the alpha diversity response to the selected
variable.
}
\description{
This function takes a batchoccupancy object and one of the variables used to
predict occupacy, and makes a plot showing the response of occupancyt against
the selected variable. This function automatically limits the values of that
variable to the maximum and minimum values of the dataset.
}
\examples{
\dontrun{
data("IslandBirds")
data("Daily_Cov")
data("siteCov")
BirdOccupancy <-batchoccu(pres = IslandBirds, sitecov = siteCov, obscov =
Daily_Cov, spp = 5, form = ~ Day + Wind + Rime + Noise + Clouds ~
Elev + AgroFo + SecVec + Wetland)
#plot the response of occupancy to individual variables for species 4 and 5

responseplot.occu(batch = BirdOccupancy, spp = 4, variable = Elev)


responseplot.occu(batch = BirdOccupancy, spp = 5, variable = Elev)
}
}
\seealso{
\code{\link[DiversityOccupancy]{batchoccu}}
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
