% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotDrugRestart}
\alias{plotDrugRestart}
\title{Generate a custom ggplot2 from a summarised_result object generated with
summariseDrugRestart() function.}
\usage{
plotDrugRestart(
  result,
  facet = cdm_name + cohort_name ~ follow_up_days,
  colour = "variable_level"
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{facet}{Columns to facet by. See options with
\code{availablePlotColumns(result)}. Formula is also allowed to specify rows and
columns.}

\item{colour}{Columns to color by. See options with
\code{availablePlotColumns(result)}.}
}
\value{
A ggplot2 object.
}
\description{
Generate a custom ggplot2 from a summarised_result object generated with
summariseDrugRestart() function.
}
\examples{
\dontrun{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

conceptlist <- list("a" = 1125360, "b" = c(1503297, 1503327))
cdm <- generateDrugUtilisationCohortSet(cdm = cdm,
                                        name = "switch_cohort",
                                        conceptSet = conceptlist)

result <- cdm$cohort1 |>
  summariseDrugRestart(switchCohortTable = "switch_cohort")

plotDrugRestart(result)
}

}
