% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeForecastData.R, R/print_show.R
\name{print,ForecastData-method}
\alias{print,ForecastData-method}
\alias{show,ForecastData-method}
\alias{print,SummaryForecastData-method}
\alias{show,SummaryForecastData-method}
\title{Print and Show methods for forecast data}
\usage{
\S4method{print}{ForecastData}(x, digits = 3, ...)

\S4method{show}{ForecastData}(object)

\S4method{print}{SummaryForecastData}(x, digits = 3, ...)

\S4method{show}{SummaryForecastData}(object)

\S4method{print}{ForecastData}(x, digits = 3, ...)

\S4method{show}{ForecastData}(object)
}
\arguments{
\item{x}{An object of the class 'ForecastData' or 'SummaryForecastData'.}

\item{digits}{An integer specifying the number of significant digits to print. The default is 3.}

\item{...}{Not implemented}

\item{object}{An object of the class 'ForecastData' or 'SummaryForecastData'.}
}
\description{
Functions to print and show the contents of a data object of the class 'ForecastData' or 'SummaryForecastData'.
}
\examples{
\dontrun{ data(calibrationSample)

data(testSample) 

this.ForecastData <- makeForecastData(.predCalibration=calibrationSample[,c("LMER", "SAE", "GLM")],
.outcomeCalibration=calibrationSample[,"Insurgency"],.predTest=testSample[,c("LMER", "SAE", "GLM")],
.outcomeTest=testSample[,"Insurgency"], .modelNames=c("LMER", "SAE", "GLM"))

this.ensemble <- calibrateEnsemble(this.ForecastData, model="logit", tol=0.001,exp=3)

summary.object <- summary(this.ensemble, period="calibration") 
print(summary.object)
show(summary.object)
}
}
\references{
Montgomery, Jacob M., Florian M. Hollenbach and Michael D. Ward. (2015). Calibrating ensemble forecasting models with sparse data in the social sciences.   \emph{International Journal of Forecasting}. \bold{31}: 930-942.

Montgomery, Jacob M., Florian M. Hollenbach and Michael D. Ward. (2012). Improving Predictions Using Ensemble Bayesian Model Averaging. \emph{Political Analysis}. \bold{20}: 271-291.
}
\author{
Michael D. Ward <\email{michael.d.ward@duke.edu}> and Jacob M. Montgomery <\email{jacob.montgomery@wustl.edu}> and Florian M. Hollenbach <\email{florian.hollenbach@tamu.edu}>
}
