#include <R.h>
#include "Rmath.h"
 extern "C" {
 void chebyshev_u_polynomials(double *xin, int *xlen, int *degree) {
 double x;
 switch(degree[0]) {
  case 0:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1e+00;
    }
    break;
  case 1:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 2e+00*x;
    }
    break;
  case 2:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1e+00 + 4e+00*R_pow(x, 2.0);
    }
    break;
  case 3:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -4e+00*x + 8e+00*R_pow(x, 3.0);
    }
    break;
  case 4:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.0e+00 - 1.2e+01*R_pow(x, 2.0) + 1.6e+01*R_pow(x, 4.0);
    }
    break;
  case 5:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 6.0e+00*x - 3.2e+01*R_pow(x, 3.0) + 3.2e+01*R_pow(x, 5.0);
    }
    break;
  case 6:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.0e+00 + 2.4e+01*R_pow(x, 2.0) - 8.0e+01*R_pow(x, 4.0) + 6.4e+01*R_pow(x, 6.0);
    }
    break;
  case 7:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -8.00e+00*x + 8.00e+01*R_pow(x, 3.0) - 1.92e+02*R_pow(x, 5.0) + 1.28e+02*R_pow(x, 7.0);
    }
    break;
  case 8:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.00e+00 - 4.00e+01*R_pow(x, 2.0) + 2.40e+02*R_pow(x, 4.0) - 4.48e+02*R_pow(x, 6.0) + 2.56e+02*R_pow(x, 8.0);
    }
    break;
  case 9:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000e+01*x - 1.600e+02*R_pow(x, 3.0) + 6.720e+02*R_pow(x, 5.0) - 1.024e+03*R_pow(x, 7.0) + 5.120e+02*R_pow(x, 9.0);
    }
    break;
  case 10:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000e+00 + 6.000e+01*R_pow(x, 2.0) - 5.600e+02*R_pow(x, 4.0) + 1.792e+03*R_pow(x, 6.0) - 2.304e+03*R_pow(x, 8.0) + 1.024e+03*R_pow(x, 10.0);
    }
    break;
  case 11:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.200e+01*x + 2.800e+02*R_pow(x, 3.0) - 1.792e+03*R_pow(x, 5.0) + 4.608e+03*R_pow(x, 7.0) - 5.120e+03*R_pow(x, 9.0) + 2.048e+03*R_pow(x, 11.0);
    }
    break;
  case 12:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.0000e+00 - 8.4000e+01*R_pow(x, 2.0) + 1.1200e+03*R_pow(x, 4.0) - 5.3760e+03*R_pow(x, 6.0) + 1.1520e+04*R_pow(x, 8.0) - 1.1264e+04*R_pow(x, 10.0) + 4.0960e+03*R_pow(x, 12.0);
    }
    break;
  case 13:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.4000e+01*x - 4.4800e+02*R_pow(x, 3.0) + 4.0320e+03*R_pow(x, 5.0) - 1.5360e+04*R_pow(x, 7.0) + 2.8160e+04*R_pow(x, 9.0) - 2.4576e+04*R_pow(x, 11.0) + 8.1920e+03*R_pow(x, 13.0);
    }
    break;
  case 14:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.0000e+00 + 1.1200e+02*R_pow(x, 2.0) - 2.0160e+03*R_pow(x, 4.0) + 1.3440e+04*R_pow(x, 6.0) - 4.2240e+04*R_pow(x, 8.0) + 6.7584e+04*R_pow(x, 10.0) - 5.3248e+04*R_pow(x, 12.0) + 1.6384e+04*R_pow(x, 14.0);
    }
    break;
  case 15:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.60000e+01*x + 6.72000e+02*R_pow(x, 3.0) - 8.06400e+03*R_pow(x, 5.0) + 4.22400e+04*R_pow(x, 7.0) - 1.12640e+05*R_pow(x, 9.0) + 1.59744e+05*R_pow(x, 11.0) - 1.14688e+05*R_pow(x, 13.0) + 3.27680e+04*R_pow(x, 15.0);
    }
    break;
  case 16:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.00000e+00 - 1.44000e+02*R_pow(x, 2.0) + 3.36000e+03*R_pow(x, 4.0) - 2.95680e+04*R_pow(x, 6.0) + 1.26720e+05*R_pow(x, 8.0) - 2.92864e+05*R_pow(x, 10.0) + 3.72736e+05*R_pow(x, 12.0) - 2.45760e+05*R_pow(x, 14.0) + 6.55360e+04*R_pow(x, 16.0);
    }
    break;
  case 17:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.80000e+01*x - 9.60000e+02*R_pow(x, 3.0) + 1.47840e+04*R_pow(x, 5.0) - 1.01376e+05*R_pow(x, 7.0) + 3.66080e+05*R_pow(x, 9.0) - 7.45472e+05*R_pow(x, 11.0) + 8.60160e+05*R_pow(x, 13.0) - 5.24288e+05*R_pow(x, 15.0) + 1.31072e+05*R_pow(x, 17.0);
    }
    break;
  case 18:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 1.800000e+02*R_pow(x, 2.0) - 5.280000e+03*R_pow(x, 4.0) + 5.913600e+04*R_pow(x, 6.0) - 3.294720e+05*R_pow(x, 8.0) + 1.025024e+06*R_pow(x, 10.0) - 1.863680e+06*R_pow(x, 12.0) + 1.966080e+06*R_pow(x, 14.0) - 1.114112e+06*R_pow(x, 16.0) + 2.621440e+05*R_pow(x, 18.0);
    }
    break;
  case 19:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -2.000000e+01*x + 1.320000e+03*R_pow(x, 3.0) - 2.534400e+04*R_pow(x, 5.0) + 2.196480e+05*R_pow(x, 7.0) - 1.025024e+06*R_pow(x, 9.0) + 2.795520e+06*R_pow(x, 11.0) - 4.587520e+06*R_pow(x, 13.0) + 4.456448e+06*R_pow(x, 15.0) - 2.359296e+06*R_pow(x, 17.0) + 5.242880e+05*R_pow(x, 19.0);
    }
    break;
  case 20:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 2.200000e+02*R_pow(x, 2.0) + 7.920000e+03*R_pow(x, 4.0) - 1.098240e+05*R_pow(x, 6.0) + 7.687680e+05*R_pow(x, 8.0) - 3.075072e+06*R_pow(x, 10.0) + 7.454720e+06*R_pow(x, 12.0) - 1.114112e+07*R_pow(x, 14.0) + 1.002701e+07*R_pow(x, 16.0) - 4.980736e+06*R_pow(x, 18.0) + 1.048576e+06*R_pow(x, 20.0);
    }
    break;
  case 21:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 2.200000e+01*x - 1.760000e+03*R_pow(x, 3.0) + 4.118400e+04*R_pow(x, 5.0) - 4.392960e+05*R_pow(x, 7.0) + 2.562560e+06*R_pow(x, 9.0) - 8.945664e+06*R_pow(x, 11.0) + 1.949696e+07*R_pow(x, 13.0) - 2.673869e+07*R_pow(x, 15.0) + 2.241331e+07*R_pow(x, 17.0) - 1.048576e+07*R_pow(x, 19.0) + 2.097152e+06*R_pow(x, 21.0);
    }
    break;
  case 22:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 2.640000e+02*R_pow(x, 2.0) - 1.144000e+04*R_pow(x, 4.0) + 1.921920e+05*R_pow(x, 6.0) - 1.647360e+06*R_pow(x, 8.0) + 8.200192e+06*R_pow(x, 10.0) - 2.534605e+07*R_pow(x, 12.0) + 5.013504e+07*R_pow(x, 14.0) - 6.350438e+07*R_pow(x, 16.0) + 4.980736e+07*R_pow(x, 18.0) - 2.202010e+07*R_pow(x, 20.0) + 4.194304e+06*R_pow(x, 22.0);
    }
    break;
  case 23:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -2.400000e+01*x + 2.288000e+03*R_pow(x, 3.0) - 6.406400e+04*R_pow(x, 5.0) + 8.236800e+05*R_pow(x, 7.0) - 5.857280e+06*R_pow(x, 9.0) + 2.534605e+07*R_pow(x, 11.0) - 7.018906e+07*R_pow(x, 13.0) + 1.270088e+08*R_pow(x, 15.0) - 1.494221e+08*R_pow(x, 17.0) + 1.101005e+08*R_pow(x, 19.0) - 4.613734e+07*R_pow(x, 21.0) + 8.388608e+06*R_pow(x, 23.0);
    }
    break;
  case 24:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 3.120000e+02*R_pow(x, 2.0) + 1.601600e+04*R_pow(x, 4.0) - 3.203200e+05*R_pow(x, 6.0) + 3.294720e+06*R_pow(x, 8.0) - 1.991475e+07*R_pow(x, 10.0) + 7.603814e+07*R_pow(x, 12.0) - 1.905132e+08*R_pow(x, 14.0) + 3.175219e+08*R_pow(x, 16.0) - 3.486515e+08*R_pow(x, 18.0) + 2.422211e+08*R_pow(x, 20.0) - 9.646899e+07*R_pow(x, 22.0) + 1.677722e+07*R_pow(x, 24.0);
    }
    break;
  case 25:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 2.600000e+01*x - 2.912000e+03*R_pow(x, 3.0) + 9.609600e+04*R_pow(x, 5.0) - 1.464320e+06*R_pow(x, 7.0) + 1.244672e+07*R_pow(x, 9.0) - 6.517555e+07*R_pow(x, 11.0) + 2.222653e+08*R_pow(x, 13.0) - 5.080351e+08*R_pow(x, 15.0) + 7.844659e+08*R_pow(x, 17.0) - 8.074035e+08*R_pow(x, 19.0) + 5.305795e+08*R_pow(x, 21.0) - 2.013266e+08*R_pow(x, 23.0) + 3.355443e+07*R_pow(x, 25.0);
    }
    break;
  case 26:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 3.640000e+02*R_pow(x, 2.0) - 2.184000e+04*R_pow(x, 4.0) + 5.125120e+05*R_pow(x, 6.0) - 6.223360e+06*R_pow(x, 8.0) + 4.480819e+07*R_pow(x, 10.0) - 2.063892e+08*R_pow(x, 12.0) + 6.350438e+08*R_pow(x, 14.0) - 1.333592e+09*R_pow(x, 16.0) + 1.917583e+09*R_pow(x, 18.0) - 1.857028e+09*R_pow(x, 20.0) + 1.157628e+09*R_pow(x, 22.0) - 4.194304e+08*R_pow(x, 24.0) + 6.710886e+07*R_pow(x, 26.0);
    }
    break;
  case 27:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -2.800000e+01*x + 3.640000e+03*R_pow(x, 3.0) - 1.397760e+05*R_pow(x, 5.0) + 2.489344e+06*R_pow(x, 7.0) - 2.489344e+07*R_pow(x, 9.0) + 1.547919e+08*R_pow(x, 11.0) - 6.350438e+08*R_pow(x, 13.0) + 1.778123e+09*R_pow(x, 15.0) - 3.451650e+09*R_pow(x, 17.0) + 4.642570e+09*R_pow(x, 19.0) - 4.244636e+09*R_pow(x, 21.0) + 2.516582e+09*R_pow(x, 23.0) - 8.724152e+08*R_pow(x, 25.0) + 1.342177e+08*R_pow(x, 27.0);
    }
    break;
  case 28:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 4.200000e+02*R_pow(x, 2.0) + 2.912000e+04*R_pow(x, 4.0) - 7.920640e+05*R_pow(x, 6.0) + 1.120205e+07*R_pow(x, 8.0) - 9.459507e+07*R_pow(x, 10.0) + 5.159731e+08*R_pow(x, 12.0) - 1.905132e+09*R_pow(x, 14.0) + 4.889838e+09*R_pow(x, 16.0) - 8.820883e+09*R_pow(x, 18.0) + 1.114217e+10*R_pow(x, 20.0) - 9.646899e+09*R_pow(x, 22.0) + 5.452595e+09*R_pow(x, 24.0) - 1.811939e+09*R_pow(x, 26.0) + 2.684355e+08*R_pow(x, 28.0);
    }
    break;
  case 29:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 3.000000e+01*x - 4.480000e+03*R_pow(x, 3.0) + 1.980160e+05*R_pow(x, 5.0) - 4.073472e+06*R_pow(x, 7.0) + 4.729754e+07*R_pow(x, 9.0) - 3.439821e+08*R_pow(x, 11.0) + 1.666990e+09*R_pow(x, 13.0) - 5.588386e+09*R_pow(x, 15.0) + 1.323133e+10*R_pow(x, 17.0) - 2.228434e+10*R_pow(x, 19.0) + 2.652897e+10*R_pow(x, 21.0) - 2.181038e+10*R_pow(x, 23.0) + 1.177761e+10*R_pow(x, 25.0) - 3.758096e+09*R_pow(x, 27.0) + 5.368709e+08*R_pow(x, 29.0);
    }
    break;
  case 30:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 4.800000e+02*R_pow(x, 2.0) - 3.808000e+04*R_pow(x, 4.0) + 1.188096e+06*R_pow(x, 6.0) - 1.934899e+07*R_pow(x, 8.0) + 1.891901e+08*R_pow(x, 10.0) - 1.203937e+09*R_pow(x, 12.0) + 5.239112e+09*R_pow(x, 14.0) - 1.606661e+10*R_pow(x, 16.0) + 3.528353e+10*R_pow(x, 18.0) - 5.571084e+10*R_pow(x, 20.0) + 6.270484e+10*R_pow(x, 22.0) - 4.907336e+10*R_pow(x, 24.0) + 2.536715e+10*R_pow(x, 26.0) - 7.784628e+09*R_pow(x, 28.0) + 1.073742e+09*R_pow(x, 30.0);
    }
    break;
  case 31:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -3.200000e+01*x + 5.440000e+03*R_pow(x, 3.0) - 2.741760e+05*R_pow(x, 5.0) + 6.449664e+06*R_pow(x, 7.0) - 8.599552e+07*R_pow(x, 9.0) + 7.223624e+08*R_pow(x, 11.0) - 4.074865e+09*R_pow(x, 13.0) + 1.606661e+10*R_pow(x, 15.0) - 4.536454e+10*R_pow(x, 17.0) + 9.285140e+10*R_pow(x, 19.0) - 1.379507e+11*R_pow(x, 21.0) + 1.472201e+11*R_pow(x, 23.0) - 1.099243e+11*R_pow(x, 25.0) + 5.449240e+10*R_pow(x, 27.0) - 1.610613e+10*R_pow(x, 29.0) + 2.147484e+09*R_pow(x, 31.0);
    }
    break;
  case 32:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 5.440000e+02*R_pow(x, 2.0) + 4.896000e+04*R_pow(x, 4.0) - 1.736448e+06*R_pow(x, 6.0) + 3.224832e+07*R_pow(x, 8.0) - 3.611812e+08*R_pow(x, 10.0) + 2.648662e+09*R_pow(x, 12.0) - 1.338884e+10*R_pow(x, 14.0) + 4.819983e+10*R_pow(x, 16.0) - 1.260126e+11*R_pow(x, 18.0) + 2.414137e+11*R_pow(x, 20.0) - 3.386062e+11*R_pow(x, 22.0) + 3.435135e+11*R_pow(x, 24.0) - 2.452158e+11*R_pow(x, 26.0) + 1.167694e+11*R_pow(x, 28.0) - 3.328600e+10*R_pow(x, 30.0) + 4.294967e+09*R_pow(x, 32.0);
    }
    break;
  case 33:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 3.400000e+01*x - 6.528000e+03*R_pow(x, 3.0) + 3.720960e+05*R_pow(x, 5.0) - 9.922560e+06*R_pow(x, 7.0) + 1.504922e+08*R_pow(x, 9.0) - 1.444725e+09*R_pow(x, 11.0) + 9.372189e+09*R_pow(x, 13.0) - 4.284429e+10*R_pow(x, 15.0) + 1.417642e+11*R_pow(x, 17.0) - 3.448766e+11*R_pow(x, 19.0) + 6.207780e+11*R_pow(x, 21.0) - 8.244324e+11*R_pow(x, 23.0) + 7.969513e+11*R_pow(x, 25.0) - 5.449240e+11*R_pow(x, 27.0) + 2.496450e+11*R_pow(x, 29.0) - 6.871948e+10*R_pow(x, 31.0) + 8.589935e+09*R_pow(x, 33.0);
    }
    break;
  case 34:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 6.120000e+02*R_pow(x, 2.0) - 6.201600e+04*R_pow(x, 4.0) + 2.480640e+06*R_pow(x, 6.0) - 5.209344e+07*R_pow(x, 8.0) + 6.621655e+08*R_pow(x, 10.0) - 5.538111e+09*R_pow(x, 12.0) + 3.213322e+10*R_pow(x, 14.0) - 1.338884e+11*R_pow(x, 16.0) + 4.095410e+11*R_pow(x, 18.0) - 9.311669e+11*R_pow(x, 20.0) + 1.580162e+12*R_pow(x, 22.0) - 1.992378e+12*R_pow(x, 24.0) + 1.839118e+12*R_pow(x, 26.0) - 1.206617e+12*R_pow(x, 28.0) + 5.325759e+11*R_pow(x, 30.0) - 1.417339e+11*R_pow(x, 32.0) + 1.717987e+10*R_pow(x, 34.0);
    }
    break;
  case 35:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -3.600000e+01*x + 7.752000e+03*R_pow(x, 3.0) - 4.961280e+05*R_pow(x, 5.0) + 1.488384e+07*R_pow(x, 7.0) - 2.546790e+08*R_pow(x, 9.0) + 2.769056e+09*R_pow(x, 11.0) - 2.044841e+10*R_pow(x, 13.0) + 1.071107e+11*R_pow(x, 15.0) - 4.095410e+11*R_pow(x, 17.0) + 1.163959e+12*R_pow(x, 19.0) - 2.483112e+12*R_pow(x, 21.0) + 3.984757e+12*R_pow(x, 23.0) - 4.781708e+12*R_pow(x, 25.0) + 4.223161e+12*R_pow(x, 27.0) - 2.662880e+12*R_pow(x, 29.0) + 1.133871e+12*R_pow(x, 31.0) - 2.920578e+11*R_pow(x, 33.0) + 3.435974e+10*R_pow(x, 35.0);
    }
    break;
  case 36:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 6.840000e+02*R_pow(x, 2.0) + 7.752000e+04*R_pow(x, 4.0) - 3.472896e+06*R_pow(x, 6.0) + 8.186112e+07*R_pow(x, 8.0) - 1.171524e+09*R_pow(x, 10.0) + 1.107622e+10*R_pow(x, 12.0) - 7.303004e+10*R_pow(x, 14.0) + 3.481099e+11*R_pow(x, 16.0) - 1.228623e+12*R_pow(x, 18.0) + 3.259084e+12*R_pow(x, 20.0) - 6.546386e+12*R_pow(x, 22.0) + 9.961891e+12*R_pow(x, 24.0) - 1.140253e+13*R_pow(x, 26.0) + 9.652939e+12*R_pow(x, 28.0) - 5.858335e+12*R_pow(x, 30.0) + 2.409477e+12*R_pow(x, 32.0) - 6.012954e+11*R_pow(x, 34.0) + 6.871948e+10*R_pow(x, 36.0);
    }
    break;
  case 37:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 3.800000e+01*x - 9.120000e+03*R_pow(x, 3.0) + 6.511680e+05*R_pow(x, 5.0) - 2.182963e+07*R_pow(x, 7.0) + 4.184013e+08*R_pow(x, 9.0) - 5.112103e+09*R_pow(x, 11.0) + 4.260086e+10*R_pow(x, 13.0) - 2.531708e+11*R_pow(x, 15.0) + 1.105761e+12*R_pow(x, 17.0) - 3.621205e+12*R_pow(x, 19.0) + 9.001280e+12*R_pow(x, 21.0) - 1.707753e+13*R_pow(x, 23.0) + 2.470549e+13*R_pow(x, 25.0) - 2.702823e+13*R_pow(x, 27.0) + 2.196876e+13*R_pow(x, 29.0) - 1.285054e+13*R_pow(x, 31.0) + 5.111011e+12*R_pow(x, 33.0) - 1.236951e+12*R_pow(x, 35.0) + 1.374390e+11*R_pow(x, 37.0);
    }
    break;
  case 38:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 7.600000e+02*R_pow(x, 2.0) - 9.576000e+04*R_pow(x, 4.0) + 4.775232e+06*R_pow(x, 6.0) - 1.255204e+08*R_pow(x, 8.0) + 2.008326e+09*R_pow(x, 10.0) - 2.130043e+10*R_pow(x, 12.0) + 1.582318e+11*R_pow(x, 14.0) - 8.544515e+11*R_pow(x, 16.0) + 3.440145e+12*R_pow(x, 18.0) - 1.050149e+13*R_pow(x, 20.0) + 2.454895e+13*R_pow(x, 22.0) - 4.411695e+13*R_pow(x, 24.0) + 6.081352e+13*R_pow(x, 26.0) - 6.370940e+13*R_pow(x, 28.0) + 4.979585e+13*R_pow(x, 30.0) - 2.811056e+13*R_pow(x, 32.0) + 1.082332e+13*R_pow(x, 34.0) - 2.542621e+12*R_pow(x, 36.0) + 2.748779e+11*R_pow(x, 38.0);
    }
    break;
  case 39:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -4.000000e+01*x + 1.064000e+04*R_pow(x, 3.0) - 8.426880e+05*R_pow(x, 5.0) + 3.138010e+07*R_pow(x, 7.0) - 6.694420e+08*R_pow(x, 9.0) + 9.128755e+09*R_pow(x, 11.0) - 8.520172e+10*R_pow(x, 13.0) + 5.696343e+11*R_pow(x, 15.0) - 2.814664e+12*R_pow(x, 17.0) + 1.050149e+13*R_pow(x, 19.0) - 3.000427e+13*R_pow(x, 21.0) + 6.617542e+13*R_pow(x, 23.0) - 1.129394e+14*R_pow(x, 25.0) + 1.486553e+14*R_pow(x, 27.0) - 1.493876e+14*R_pow(x, 29.0) + 1.124422e+14*R_pow(x, 31.0) - 6.133213e+13*R_pow(x, 33.0) + 2.288359e+13*R_pow(x, 35.0) - 5.222680e+12*R_pow(x, 37.0) + 5.497558e+11*R_pow(x, 39.0);
    }
    break;
  case 40:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 8.400000e+02*R_pow(x, 2.0) + 1.170400e+05*R_pow(x, 4.0) - 6.460608e+06*R_pow(x, 6.0) + 1.882806e+08*R_pow(x, 8.0) - 3.347210e+09*R_pow(x, 10.0) + 3.955794e+10*R_pow(x, 12.0) - 3.286352e+11*R_pow(x, 14.0) + 1.993720e+12*R_pow(x, 16.0) - 9.069472e+12*R_pow(x, 18.0) + 3.150448e+13*R_pow(x, 20.0) - 8.455748e+13*R_pow(x, 22.0) + 1.764678e+14*R_pow(x, 24.0) - 2.866923e+14*R_pow(x, 26.0) + 3.610199e+14*R_pow(x, 28.0) - 3.485710e+14*R_pow(x, 30.0) + 2.529950e+14*R_pow(x, 32.0) - 1.334876e+14*R_pow(x, 34.0) + 4.830979e+13*R_pow(x, 36.0) - 1.072024e+13*R_pow(x, 38.0) + 1.099512e+12*R_pow(x, 40.0);
    }
    break;
  case 41:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 4.200000e+01*x - 1.232000e+04*R_pow(x, 3.0) + 1.076768e+06*R_pow(x, 5.0) - 4.430131e+07*R_pow(x, 7.0) + 1.046003e+09*R_pow(x, 9.0) - 1.582318e+10*R_pow(x, 11.0) + 1.643176e+11*R_pow(x, 13.0) - 1.226905e+12*R_pow(x, 15.0) + 6.802104e+12*R_pow(x, 17.0) - 2.864044e+13*R_pow(x, 19.0) + 9.301323e+13*R_pow(x, 21.0) - 2.352904e+14*R_pow(x, 23.0) + 4.658750e+14*R_pow(x, 25.0) - 7.220398e+14*R_pow(x, 27.0) + 8.714274e+14*R_pow(x, 29.0) - 8.095842e+14*R_pow(x, 31.0) + 5.673222e+14*R_pow(x, 33.0) - 2.898588e+14*R_pow(x, 35.0) + 1.018423e+14*R_pow(x, 37.0) - 2.199023e+13*R_pow(x, 39.0) + 2.199023e+12*R_pow(x, 41.0);
    }
    break;
  case 42:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 9.240000e+02*R_pow(x, 2.0) - 1.416800e+05*R_pow(x, 4.0) + 8.614144e+06*R_pow(x, 6.0) - 2.768832e+08*R_pow(x, 8.0) + 5.439217e+09*R_pow(x, 10.0) - 7.120429e+10*R_pow(x, 12.0) + 6.572704e+11*R_pow(x, 14.0) - 4.447530e+12*R_pow(x, 16.0) + 2.267368e+13*R_pow(x, 18.0) - 8.878536e+13*R_pow(x, 20.0) + 2.705839e+14*R_pow(x, 22.0) - 6.470486e+14*R_pow(x, 24.0) + 1.218442e+15*R_pow(x, 26.0) - 1.805100e+15*R_pow(x, 28.0) + 2.091426e+15*R_pow(x, 30.0) - 1.872163e+15*R_pow(x, 32.0) + 1.268132e+15*R_pow(x, 34.0) - 6.280273e+14*R_pow(x, 36.0) + 2.144048e+14*R_pow(x, 38.0) - 4.507998e+13*R_pow(x, 40.0) + 4.398047e+12*R_pow(x, 42.0);
    }
    break;
  case 43:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -4.400000e+01*x + 1.416800e+04*R_pow(x, 3.0) - 1.360128e+06*R_pow(x, 5.0) + 6.152960e+07*R_pow(x, 7.0) - 1.599770e+09*R_pow(x, 9.0) + 2.670161e+10*R_pow(x, 11.0) - 3.067262e+11*R_pow(x, 13.0) + 2.541445e+12*R_pow(x, 15.0) - 1.569716e+13*R_pow(x, 17.0) + 7.398780e+13*R_pow(x, 19.0) - 2.705839e+14*R_pow(x, 21.0) + 7.764583e+14*R_pow(x, 23.0) - 1.759972e+15*R_pow(x, 25.0) + 3.158924e+15*R_pow(x, 27.0) - 4.481627e+15*R_pow(x, 29.0) + 4.992436e+15*R_pow(x, 31.0) - 4.311649e+15*R_pow(x, 33.0) + 2.826123e+15*R_pow(x, 35.0) - 1.357897e+15*R_pow(x, 37.0) + 4.507998e+14*R_pow(x, 39.0) - 9.235898e+13*R_pow(x, 41.0) + 8.796093e+12*R_pow(x, 43.0);
    }
    break;
  case 44:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 1.012000e+03*R_pow(x, 2.0) + 1.700160e+05*R_pow(x, 4.0) - 1.133440e+07*R_pow(x, 6.0) + 3.999424e+08*R_pow(x, 8.0) - 8.638756e+09*R_pow(x, 10.0) + 1.246075e+11*R_pow(x, 12.0) - 1.270723e+12*R_pow(x, 14.0) + 9.530420e+12*R_pow(x, 16.0) - 5.406801e+13*R_pow(x, 18.0) + 2.367610e+14*R_pow(x, 20.0) - 8.117518e+14*R_pow(x, 22.0) + 2.199965e+15*R_pow(x, 24.0) - 4.738386e+15*R_pow(x, 26.0) + 8.122948e+15*R_pow(x, 28.0) - 1.105468e+16*R_pow(x, 30.0) + 1.185703e+16*R_pow(x, 32.0) - 9.891430e+15*R_pow(x, 34.0) + 6.280273e+15*R_pow(x, 36.0) - 2.930198e+15*R_pow(x, 38.0) + 9.466795e+14*R_pow(x, 40.0) - 1.891160e+14*R_pow(x, 42.0) + 1.759219e+13*R_pow(x, 44.0);
    }
    break;
  case 45:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 4.600000e+01*x - 1.619200e+04*R_pow(x, 3.0) + 1.700160e+06*R_pow(x, 5.0) - 8.419840e+07*R_pow(x, 7.0) + 2.399654e+09*R_pow(x, 9.0) - 4.397912e+10*R_pow(x, 11.0) + 5.559412e+11*R_pow(x, 13.0) - 5.082891e+12*R_pow(x, 15.0) + 3.475800e+13*R_pow(x, 17.0) - 1.821238e+14*R_pow(x, 19.0) + 7.441059e+14*R_pow(x, 21.0) - 2.399962e+15*R_pow(x, 23.0) + 6.159902e+15*R_pow(x, 25.0) - 1.263570e+16*R_pow(x, 27.0) + 2.072752e+16*R_pow(x, 29.0) - 2.710179e+16*R_pow(x, 31.0) + 2.802572e+16*R_pow(x, 33.0) - 2.260898e+16*R_pow(x, 35.0) + 1.391844e+16*R_pow(x, 37.0) - 6.311197e+15*R_pow(x, 39.0) + 1.985718e+15*R_pow(x, 41.0) - 3.870281e+14*R_pow(x, 43.0) + 3.518437e+13*R_pow(x, 45.0);
    }
    break;
  case 46:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 1.104000e+03*R_pow(x, 2.0) - 2.024000e+05*R_pow(x, 4.0) + 1.473472e+07*R_pow(x, 6.0) - 5.683392e+08*R_pow(x, 8.0) + 1.343806e+10*R_pow(x, 10.0) - 2.125657e+11*R_pow(x, 12.0) + 2.382605e+12*R_pow(x, 14.0) - 1.969620e+13*R_pow(x, 16.0) + 1.235840e+14*R_pow(x, 18.0) - 6.010086e+14*R_pow(x, 20.0) + 2.299964e+15*R_pow(x, 22.0) - 6.999889e+15*R_pow(x, 24.0) + 1.705819e+16*R_pow(x, 26.0) - 3.339434e+16*R_pow(x, 28.0) + 5.250972e+16*R_pow(x, 30.0) - 6.606062e+16*R_pow(x, 32.0) + 6.594287e+16*R_pow(x, 34.0) - 5.149824e+16*R_pow(x, 36.0) + 3.076708e+16*R_pow(x, 38.0) - 1.356907e+16*R_pow(x, 40.0) + 4.160552e+15*R_pow(x, 42.0) - 7.916484e+14*R_pow(x, 44.0) + 7.036874e+13*R_pow(x, 46.0);
    }
    break;
  case 47:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -4.800000e+01*x + 1.840000e+04*R_pow(x, 3.0) - 2.104960e+06*R_pow(x, 5.0) + 1.136678e+08*R_pow(x, 7.0) - 3.536333e+09*R_pow(x, 9.0) + 7.085525e+10*R_pow(x, 11.0) - 9.810727e+11*R_pow(x, 13.0) + 9.848101e+12*R_pow(x, 15.0) - 7.415041e+13*R_pow(x, 17.0) + 4.292918e+14*R_pow(x, 19.0) - 1.946123e+15*R_pow(x, 21.0) + 6.999889e+15*R_pow(x, 23.0) - 2.015968e+16*R_pow(x, 25.0) + 4.675208e+16*R_pow(x, 27.0) - 8.751621e+16*R_pow(x, 29.0) + 1.321212e+17*R_pow(x, 31.0) - 1.601470e+17*R_pow(x, 33.0) + 1.544947e+17*R_pow(x, 35.0) - 1.169149e+17*R_pow(x, 37.0) + 6.784536e+16*R_pow(x, 39.0) - 2.912386e+16*R_pow(x, 41.0) + 8.708132e+15*R_pow(x, 43.0) - 1.618481e+15*R_pow(x, 45.0) + 1.407375e+14*R_pow(x, 47.0);
    }
    break;
  case 48:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 1.200000e+03*R_pow(x, 2.0) + 2.392000e+05*R_pow(x, 4.0) - 1.894464e+07*R_pow(x, 6.0) + 7.956749e+08*R_pow(x, 8.0) - 2.051073e+10*R_pow(x, 10.0) + 3.542762e+11*R_pow(x, 12.0) - 4.344750e+12*R_pow(x, 14.0) + 3.939240e+13*R_pow(x, 16.0) - 2.718848e+14*R_pow(x, 18.0) + 1.459592e+15*R_pow(x, 20.0) - 6.192210e+15*R_pow(x, 22.0) + 2.099967e+16*R_pow(x, 24.0) - 5.737755e+16*R_pow(x, 26.0) + 1.268985e+17*R_pow(x, 28.0) - 2.275421e+17*R_pow(x, 30.0) + 3.303031e+17*R_pow(x, 32.0) - 3.862368e+17*R_pow(x, 34.0) + 3.604877e+17*R_pow(x, 36.0) - 2.645969e+17*R_pow(x, 38.0) + 1.492598e+17*R_pow(x, 40.0) - 6.240828e+16*R_pow(x, 42.0) + 1.820791e+16*R_pow(x, 44.0) - 3.307331e+15*R_pow(x, 46.0) + 2.814750e+14*R_pow(x, 48.0);
    }
    break;
  case 49:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 5.000000e+01*x - 2.080000e+04*R_pow(x, 3.0) + 2.583360e+06*R_pow(x, 5.0) - 1.515571e+08*R_pow(x, 7.0) + 5.127683e+09*R_pow(x, 9.0) - 1.118767e+11*R_pow(x, 11.0) + 1.689625e+12*R_pow(x, 13.0) - 1.853760e+13*R_pow(x, 15.0) + 1.529352e+14*R_pow(x, 17.0) - 9.730615e+14*R_pow(x, 19.0) + 4.865307e+15*R_pow(x, 21.0) - 1.938431e+16*R_pow(x, 23.0) + 6.215901e+16*R_pow(x, 25.0) - 1.615072e+17*R_pow(x, 27.0) + 3.413132e+17*R_pow(x, 29.0) - 5.872055e+17*R_pow(x, 31.0) + 8.207532e+17*R_pow(x, 33.0) - 9.269683e+17*R_pow(x, 35.0) + 8.378903e+17*R_pow(x, 37.0) - 5.970392e+17*R_pow(x, 39.0) + 3.276435e+17*R_pow(x, 41.0) - 1.335247e+17*R_pow(x, 43.0) + 3.803431e+16*R_pow(x, 45.0) - 6.755399e+15*R_pow(x, 47.0) + 5.629500e+14*R_pow(x, 49.0);
    }
    break;
  case 50:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 1.300000e+03*R_pow(x, 2.0) - 2.808000e+05*R_pow(x, 4.0) + 2.411136e+07*R_pow(x, 6.0) - 1.098789e+09*R_pow(x, 8.0) + 3.076610e+10*R_pow(x, 10.0) - 5.780297e+11*R_pow(x, 12.0) + 7.724001e+12*R_pow(x, 14.0) - 7.646761e+13*R_pow(x, 16.0) + 5.777553e+14*R_pow(x, 18.0) - 3.405715e+15*R_pow(x, 20.0) + 1.592282e+16*R_pow(x, 22.0) - 5.976828e+16*R_pow(x, 24.0) + 1.816956e+17*R_pow(x, 26.0) - 4.499129e+17*R_pow(x, 28.0) + 9.101686e+17*R_pow(x, 30.0) - 1.504714e+18*R_pow(x, 32.0) + 2.027743e+18*R_pow(x, 34.0) - 2.214424e+18*R_pow(x, 36.0) + 1.940377e+18*R_pow(x, 38.0) - 1.343338e+18*R_pow(x, 40.0) + 7.176952e+17*R_pow(x, 42.0) - 2.852573e+17*R_pow(x, 44.0) + 7.937594e+16*R_pow(x, 46.0) - 1.379227e+16*R_pow(x, 48.0) + 1.125900e+15*R_pow(x, 50.0);
    }
    break;
  case 51:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -5.200000e+01*x + 2.340000e+04*R_pow(x, 3.0) - 3.144960e+06*R_pow(x, 5.0) + 1.997798e+08*R_pow(x, 7.0) - 7.325261e+09*R_pow(x, 9.0) + 1.734089e+11*R_pow(x, 11.0) - 2.845685e+12*R_pow(x, 13.0) + 3.398560e+13*R_pow(x, 15.0) - 3.058704e+14*R_pow(x, 17.0) + 2.128572e+15*R_pow(x, 19.0) - 1.167674e+16*R_pow(x, 21.0) + 5.122996e+16*R_pow(x, 23.0) - 1.816956e+17*R_pow(x, 25.0) + 5.248983e+17*R_pow(x, 27.0) - 1.241139e+18*R_pow(x, 29.0) + 2.407543e+18*R_pow(x, 31.0) - 3.830181e+18*R_pow(x, 33.0) + 4.982455e+18*R_pow(x, 35.0) - 5.266739e+18*R_pow(x, 37.0) + 4.477794e+18*R_pow(x, 39.0) - 3.014320e+18*R_pow(x, 41.0) + 1.568915e+18*R_pow(x, 43.0) - 6.085489e+17*R_pow(x, 45.0) + 1.655073e+17*R_pow(x, 47.0) - 2.814750e+16*R_pow(x, 49.0) + 2.251800e+15*R_pow(x, 51.0);
    }
    break;
  case 52:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 1.404000e+03*R_pow(x, 2.0) + 3.276000e+05*R_pow(x, 4.0) - 3.040128e+07*R_pow(x, 6.0) + 1.498349e+09*R_pow(x, 8.0) - 4.541662e+10*R_pow(x, 10.0) + 9.248475e+11*R_pow(x, 12.0) - 1.341537e+13*R_pow(x, 14.0) + 1.444388e+14*R_pow(x, 16.0) - 1.189496e+15*R_pow(x, 18.0) + 7.662859e+15*R_pow(x, 20.0) - 3.927630e+16*R_pow(x, 22.0) + 1.622282e+17*R_pow(x, 24.0) - 5.450867e+17*R_pow(x, 26.0) + 1.499710e+18*R_pow(x, 28.0) - 3.392446e+18*R_pow(x, 30.0) + 6.319799e+18*R_pow(x, 32.0) - 9.688106e+18*R_pow(x, 34.0) + 1.217933e+19*R_pow(x, 36.0) - 1.247385e+19*R_pow(x, 38.0) + 1.029893e+19*R_pow(x, 40.0) - 6.746335e+18*R_pow(x, 42.0) + 3.423088e+18*R_pow(x, 44.0) - 1.296474e+18*R_pow(x, 46.0) + 3.448068e+17*R_pow(x, 48.0) - 5.742090e+16*R_pow(x, 50.0) + 4.503600e+15*R_pow(x, 52.0);
    }
    break;
  case 53:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 5.400000e+01*x - 2.620800e+04*R_pow(x, 3.0) + 3.800160e+06*R_pow(x, 5.0) - 2.605824e+08*R_pow(x, 7.0) + 1.032196e+10*R_pow(x, 9.0) - 2.642421e+11*R_pow(x, 11.0) + 4.695379e+12*R_pow(x, 13.0) - 6.081634e+13*R_pow(x, 15.0) + 5.947481e+14*R_pow(x, 17.0) - 4.507564e+15*R_pow(x, 19.0) + 2.700246e+16*R_pow(x, 21.0) - 1.297826e+17*R_pow(x, 23.0) + 5.061520e+17*R_pow(x, 25.0) - 1.615072e+18*R_pow(x, 27.0) + 4.240558e+18*R_pow(x, 29.0) - 9.192436e+18*R_pow(x, 31.0) + 1.646978e+19*R_pow(x, 33.0) - 2.435867e+19*R_pow(x, 35.0) + 2.962541e+19*R_pow(x, 37.0) - 2.942550e+19*R_pow(x, 39.0) + 2.361217e+19*R_pow(x, 41.0) - 1.506159e+19*R_pow(x, 43.0) + 7.454724e+18*R_pow(x, 45.0) - 2.758455e+18*R_pow(x, 47.0) + 7.177612e+17*R_pow(x, 49.0) - 1.170936e+17*R_pow(x, 51.0) + 9.007199e+15*R_pow(x, 53.0);
    }
    break;
  case 54:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 1.512000e+03*R_pow(x, 2.0) - 3.800160e+05*R_pow(x, 4.0) + 3.800160e+07*R_pow(x, 6.0) - 2.019514e+09*R_pow(x, 8.0) + 6.606053e+10*R_pow(x, 10.0) - 1.453332e+12*R_pow(x, 12.0) + 2.280613e+13*R_pow(x, 14.0) - 2.660715e+14*R_pow(x, 16.0) + 2.378992e+15*R_pow(x, 18.0) - 1.667799e+16*R_pow(x, 20.0) + 9.328121e+16*R_pow(x, 22.0) - 4.217933e+17*R_pow(x, 24.0) + 1.557391e+18*R_pow(x, 26.0) - 4.729853e+18*R_pow(x, 28.0) + 1.187356e+19*R_pow(x, 30.0) - 2.470467e+19*R_pow(x, 32.0) + 4.262767e+19*R_pow(x, 34.0) - 6.089667e+19*R_pow(x, 36.0) + 7.172467e+19*R_pow(x, 38.0) - 6.914993e+19*R_pow(x, 40.0) + 5.397068e+19*R_pow(x, 42.0) - 3.354626e+19*R_pow(x, 44.0) + 1.620592e+19*R_pow(x, 46.0) - 5.861716e+18*R_pow(x, 48.0) + 1.492943e+18*R_pow(x, 50.0) - 2.386908e+17*R_pow(x, 52.0) + 1.801440e+16*R_pow(x, 54.0);
    }
    break;
  case 55:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -5.600000e+01*x + 2.923200e+04*R_pow(x, 3.0) - 4.560192e+06*R_pow(x, 5.0) + 3.365856e+08*R_pow(x, 7.0) - 1.436099e+10*R_pow(x, 9.0) + 3.963632e+11*R_pow(x, 11.0) - 7.602043e+12*R_pow(x, 13.0) + 1.064286e+14*R_pow(x, 15.0) - 1.126891e+15*R_pow(x, 17.0) + 9.265549e+15*R_pow(x, 19.0) - 6.035843e+16*R_pow(x, 21.0) + 3.163450e+17*R_pow(x, 23.0) - 1.349739e+18*R_pow(x, 25.0) + 4.729853e+18*R_pow(x, 27.0) - 1.370026e+19*R_pow(x, 29.0) + 3.293956e+19*R_pow(x, 31.0) - 6.587912e+19*R_pow(x, 33.0) + 1.096140e+20*R_pow(x, 35.0) - 1.514187e+20*R_pow(x, 37.0) + 1.728748e+20*R_pow(x, 39.0) - 1.619120e+20*R_pow(x, 41.0) + 1.230029e+20*R_pow(x, 43.0) - 7.454724e+19*R_pow(x, 45.0) + 3.517030e+19*R_pow(x, 47.0) - 1.244119e+19*R_pow(x, 49.0) + 3.102980e+18*R_pow(x, 51.0) - 4.863888e+17*R_pow(x, 53.0) + 3.602880e+16*R_pow(x, 55.0);
    }
    break;
  case 56:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 1.624000e+03*R_pow(x, 2.0) + 4.384800e+05*R_pow(x, 4.0) - 4.712198e+07*R_pow(x, 6.0) + 2.692685e+09*R_pow(x, 8.0) - 9.478250e+10*R_pow(x, 10.0) + 2.246058e+12*R_pow(x, 12.0) - 3.801021e+13*R_pow(x, 14.0) + 4.789287e+14*R_pow(x, 16.0) - 4.632774e+15*R_pow(x, 18.0) + 3.520909e+16*R_pow(x, 20.0) - 2.139981e+17*R_pow(x, 22.0) + 1.054483e+18*R_pow(x, 24.0) - 4.256868e+18*R_pow(x, 26.0) + 1.418956e+19*R_pow(x, 28.0) - 3.927409e+19*R_pow(x, 30.0) + 9.058379e+19*R_pow(x, 32.0) - 1.743859e+20*R_pow(x, 34.0) + 2.801247e+20*R_pow(x, 36.0) - 3.745621e+20*R_pow(x, 38.0) + 4.148996e+20*R_pow(x, 40.0) - 3.777948e+20*R_pow(x, 42.0) + 2.795522e+20*R_pow(x, 44.0) - 1.653004e+20*R_pow(x, 46.0) + 7.620231e+19*R_pow(x, 48.0) - 2.637533e+19*R_pow(x, 50.0) + 6.444651e+18*R_pow(x, 52.0) - 9.907919e+17*R_pow(x, 54.0) + 7.205759e+16*R_pow(x, 56.0);
    }
    break;
  case 57:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 5.800000e+01*x - 3.248000e+04*R_pow(x, 3.0) + 5.437152e+06*R_pow(x, 5.0) - 4.308296e+08*R_pow(x, 7.0) + 1.974636e+10*R_pow(x, 9.0) - 5.859282e+11*R_pow(x, 11.0) + 1.209416e+13*R_pow(x, 13.0) - 1.824490e+14*R_pow(x, 15.0) + 2.084748e+15*R_pow(x, 17.0) - 1.853110e+16*R_pow(x, 19.0) + 1.307766e+17*R_pow(x, 21.0) - 7.443411e+17*R_pow(x, 23.0) + 3.458705e+18*R_pow(x, 25.0) - 1.324359e+19*R_pow(x, 27.0) + 4.207938e+19*R_pow(x, 29.0) - 1.114877e+20*R_pow(x, 31.0) + 2.470467e+20*R_pow(x, 33.0) - 4.583858e+20*R_pow(x, 35.0) + 7.116681e+20*R_pow(x, 37.0) - 9.219991e+20*R_pow(x, 39.0) + 9.917113e+20*R_pow(x, 41.0) - 8.785925e+20*R_pow(x, 43.0) + 6.336515e+20*R_pow(x, 45.0) - 3.657711e+20*R_pow(x, 47.0) + 1.648458e+20*R_pow(x, 49.0) - 5.585364e+19*R_pow(x, 51.0) + 1.337569e+19*R_pow(x, 53.0) - 2.017613e+18*R_pow(x, 55.0) + 1.441152e+17*R_pow(x, 57.0);
    }
    break;
  case 58:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 1.740000e+03*R_pow(x, 2.0) - 5.034400e+05*R_pow(x, 4.0) + 5.799629e+07*R_pow(x, 6.0) - 3.554344e+09*R_pow(x, 8.0) + 1.342752e+11*R_pow(x, 10.0) - 3.417915e+12*R_pow(x, 12.0) + 6.219853e+13*R_pow(x, 14.0) - 8.438268e+14*R_pow(x, 16.0) + 8.802271e+15*R_pow(x, 18.0) - 7.227128e+16*R_pow(x, 20.0) + 4.755513e+17*R_pow(x, 22.0) - 2.543166e+18*R_pow(x, 24.0) + 1.117428e+19*R_pow(x, 26.0) - 4.067674e+19*R_pow(x, 28.0) + 1.234329e+20*R_pow(x, 30.0) - 3.135593e+20*R_pow(x, 32.0) + 6.684793e+20*R_pow(x, 34.0) - 1.196896e+21*R_pow(x, 36.0) + 1.797898e+21*R_pow(x, 38.0) - 2.258898e+21*R_pow(x, 40.0) + 2.361217e+21*R_pow(x, 42.0) - 2.036737e+21*R_pow(x, 44.0) + 1.432603e+21*R_pow(x, 46.0) - 8.077445e+20*R_pow(x, 48.0) + 3.560670e+20*R_pow(x, 50.0) - 1.181519e+20*R_pow(x, 52.0) + 2.774217e+19*R_pow(x, 54.0) - 4.107283e+18*R_pow(x, 56.0) + 2.882304e+17*R_pow(x, 58.0);
    }
    break;
  case 59:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -6.000000e+01*x + 3.596000e+04*R_pow(x, 3.0) - 6.444032e+06*R_pow(x, 5.0) + 5.468221e+08*R_pow(x, 7.0) - 2.685504e+10*R_pow(x, 9.0) + 8.544786e+11*R_pow(x, 11.0) - 1.892999e+13*R_pow(x, 13.0) + 3.068461e+14*R_pow(x, 15.0) - 3.772402e+15*R_pow(x, 17.0) + 3.613564e+16*R_pow(x, 19.0) - 2.753192e+17*R_pow(x, 21.0) + 1.695444e+18*R_pow(x, 23.0) - 8.545036e+18*R_pow(x, 25.0) + 3.559215e+19*R_pow(x, 27.0) - 1.234329e+20*R_pow(x, 29.0) + 3.583535e+20*R_pow(x, 31.0) - 8.741653e+20*R_pow(x, 33.0) + 1.795344e+21*R_pow(x, 35.0) - 3.105461e+21*R_pow(x, 37.0) + 4.517796e+21*R_pow(x, 39.0) - 5.509507e+21*R_pow(x, 41.0) + 5.601027e+21*R_pow(x, 43.0) - 4.707126e+21*R_pow(x, 45.0) + 3.230978e+21*R_pow(x, 47.0) - 1.780335e+21*R_pow(x, 49.0) + 7.679876e+20*R_pow(x, 51.0) - 2.496796e+20*R_pow(x, 53.0) + 5.750196e+19*R_pow(x, 55.0) - 8.358681e+18*R_pow(x, 57.0) + 5.764608e+17*R_pow(x, 59.0);
    }
    break;
  case 60:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 1.860000e+03*R_pow(x, 2.0) + 5.753600e+05*R_pow(x, 4.0) - 7.088435e+07*R_pow(x, 6.0) + 4.647988e+09*R_pow(x, 8.0) - 1.879853e+11*R_pow(x, 10.0) + 5.126872e+12*R_pow(x, 12.0) - 1.000585e+14*R_pow(x, 14.0) + 1.457519e+15*R_pow(x, 16.0) - 1.634708e+16*R_pow(x, 18.0) + 1.445426e+17*R_pow(x, 20.0) - 1.026190e+18*R_pow(x, 22.0) + 5.934053e+18*R_pow(x, 24.0) - 2.826435e+19*R_pow(x, 26.0) + 1.118610e+20*R_pow(x, 28.0) - 3.702986e+20*R_pow(x, 30.0) + 1.030266e+21*R_pow(x, 32.0) - 2.416810e+21*R_pow(x, 34.0) + 4.787585e+21*R_pow(x, 36.0) - 8.008820e+21*R_pow(x, 38.0) + 1.129449e+22*R_pow(x, 40.0) - 1.338023e+22*R_pow(x, 42.0) + 1.323879e+22*R_pow(x, 44.0) - 1.084685e+22*R_pow(x, 46.0) + 7.269701e+21*R_pow(x, 48.0) - 3.916737e+21*R_pow(x, 50.0) + 1.654127e+21*R_pow(x, 52.0) - 5.271013e+20*R_pow(x, 54.0) + 1.191112e+20*R_pow(x, 56.0) - 1.700559e+19*R_pow(x, 58.0) + 1.152922e+18*R_pow(x, 60.0);
    }
    break;
  case 61:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 6.200000e+01*x - 3.968000e+04*R_pow(x, 3.0) + 7.594752e+06*R_pow(x, 5.0) - 6.885908e+08*R_pow(x, 7.0) + 3.615102e+10*R_pow(x, 9.0) - 1.230449e+12*R_pow(x, 11.0) + 2.918373e+13*R_pow(x, 13.0) - 5.069631e+14*R_pow(x, 15.0) + 6.687440e+15*R_pow(x, 17.0) - 6.882979e+16*R_pow(x, 19.0) + 5.644043e+17*R_pow(x, 21.0) - 3.747823e+18*R_pow(x, 23.0) + 2.041314e+19*R_pow(x, 25.0) - 9.212085e+19*R_pow(x, 27.0) + 3.471549e+20*R_pow(x, 29.0) - 1.098951e+21*R_pow(x, 31.0) + 2.934698e+21*R_pow(x, 33.0) - 6.628964e+21*R_pow(x, 35.0) + 1.268063e+22*R_pow(x, 37.0) - 2.053544e+22*R_pow(x, 39.0) + 2.809849e+22*R_pow(x, 41.0) - 3.236149e+22*R_pow(x, 43.0) + 3.118471e+22*R_pow(x, 45.0) - 2.492469e+22*R_pow(x, 47.0) + 1.631974e+22*R_pow(x, 49.0) - 8.601461e+21*R_pow(x, 51.0) + 3.557934e+21*R_pow(x, 53.0) - 1.111705e+21*R_pow(x, 55.0) + 2.465811e+20*R_pow(x, 57.0) - 3.458765e+19*R_pow(x, 59.0) + 2.305843e+18*R_pow(x, 61.0);
    }
    break;
  case 62:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 1.984000e+03*R_pow(x, 2.0) - 6.547200e+05*R_pow(x, 4.0) + 8.607386e+07*R_pow(x, 6.0) - 6.025170e+09*R_pow(x, 8.0) + 2.602873e+11*R_pow(x, 10.0) - 7.587770e+12*R_pow(x, 12.0) + 1.584260e+14*R_pow(x, 14.0) - 2.471445e+15*R_pow(x, 16.0) + 2.972196e+16*R_pow(x, 18.0) - 2.822021e+17*R_pow(x, 20.0) + 2.154998e+18*R_pow(x, 22.0) - 1.342970e+19*R_pow(x, 24.0) + 6.909064e+19*R_pow(x, 26.0) - 2.961027e+20*R_pow(x, 28.0) + 1.064608e+21*R_pow(x, 30.0) - 3.228167e+21*R_pow(x, 32.0) + 8.286205e+21*R_pow(x, 34.0) - 1.804551e+22*R_pow(x, 36.0) + 3.337008e+22*R_pow(x, 38.0) - 5.236536e+22*R_pow(x, 40.0) + 6.957720e+22*R_pow(x, 42.0) - 7.796177e+22*R_pow(x, 44.0) + 7.321627e+22*R_pow(x, 46.0) - 5.711908e+22*R_pow(x, 48.0) + 3.655621e+22*R_pow(x, 50.0) - 1.885705e+22*R_pow(x, 52.0) + 7.642969e+21*R_pow(x, 54.0) - 2.342520e+21*R_pow(x, 56.0) + 5.101678e+20*R_pow(x, 58.0) - 7.032821e+19*R_pow(x, 60.0) + 4.611686e+18*R_pow(x, 62.0);
    }
    break;
  case 63:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -6.400000e+01*x + 4.364800e+04*R_pow(x, 3.0) - 8.904192e+06*R_pow(x, 5.0) + 8.607386e+08*R_pow(x, 7.0) - 4.820136e+10*R_pow(x, 9.0) + 1.751024e+12*R_pow(x, 11.0) - 4.435927e+13*R_pow(x, 13.0) + 8.238151e+14*R_pow(x, 15.0) - 1.163033e+16*R_pow(x, 17.0) + 1.282737e+17*R_pow(x, 19.0) - 1.128809e+18*R_pow(x, 21.0) + 8.057819e+18*R_pow(x, 23.0) - 4.727254e+19*R_pow(x, 25.0) + 2.303021e+20*R_pow(x, 27.0) - 9.393604e+20*R_pow(x, 29.0) + 3.228167e+21*R_pow(x, 31.0) - 9.391033e+21*R_pow(x, 33.0) + 2.320137e+22*R_pow(x, 35.0) - 4.877166e+22*R_pow(x, 37.0) + 8.727560e+22*R_pow(x, 39.0) - 1.328292e+23*R_pow(x, 41.0) + 1.715159e+23*R_pow(x, 43.0) - 1.871082e+23*R_pow(x, 45.0) + 1.713572e+23*R_pow(x, 47.0) - 1.305579e+23*R_pow(x, 49.0) + 8.171388e+22*R_pow(x, 51.0) - 4.127203e+22*R_pow(x, 53.0) + 1.639764e+22*R_pow(x, 55.0) - 4.931622e+21*R_pow(x, 57.0) + 1.054923e+21*R_pow(x, 59.0) - 1.429623e+20*R_pow(x, 61.0) + 9.223372e+18*R_pow(x, 63.0);
    }
    break;
  case 64:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 2.112000e+03*R_pow(x, 2.0) + 7.420160e+05*R_pow(x, 4.0) - 1.038822e+08*R_pow(x, 6.0) + 7.746647e+09*R_pow(x, 8.0) - 3.566901e+11*R_pow(x, 10.0) + 1.108982e+13*R_pow(x, 12.0) - 2.471445e+14*R_pow(x, 14.0) + 4.119075e+15*R_pow(x, 16.0) - 5.298262e+16*R_pow(x, 18.0) + 5.387495e+17*R_pow(x, 20.0) - 4.412615e+18*R_pow(x, 22.0) + 2.954534e+19*R_pow(x, 24.0) - 1.636357e+20*R_pow(x, 26.0) + 7.567070e+20*R_pow(x, 28.0) - 2.943329e+21*R_pow(x, 30.0) + 9.684502e+21*R_pow(x, 32.0) - 2.706827e+22*R_pow(x, 34.0) + 6.444826e+22*R_pow(x, 36.0) - 1.309134e+23*R_pow(x, 38.0) + 2.269166e+23*R_pow(x, 40.0) - 3.352356e+23*R_pow(x, 42.0) + 4.209936e+23*R_pow(x, 44.0) - 4.474328e+23*R_pow(x, 46.0) + 3.998335e+23*R_pow(x, 48.0) - 2.976720e+23*R_pow(x, 50.0) + 1.822848e+23*R_pow(x, 52.0) - 9.018703e+22*R_pow(x, 54.0) + 3.513780e+22*R_pow(x, 56.0) - 1.037341e+22*R_pow(x, 58.0) + 2.180175e+21*R_pow(x, 60.0) - 2.905362e+20*R_pow(x, 62.0) + 1.844674e+19*R_pow(x, 64.0);
    }
    break;
  case 65:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 6.600000e+01*x - 4.787200e+04*R_pow(x, 3.0) + 1.038822e+07*R_pow(x, 5.0) - 1.068503e+09*R_pow(x, 7.0) + 6.369465e+10*R_pow(x, 9.0) - 2.464404e+12*R_pow(x, 11.0) + 6.653891e+13*R_pow(x, 13.0) - 1.318104e+15*R_pow(x, 15.0) + 1.986848e+16*R_pow(x, 17.0) - 2.342389e+17*R_pow(x, 19.0) + 2.206308e+18*R_pow(x, 21.0) - 1.688305e+19*R_pow(x, 23.0) + 1.063632e+20*R_pow(x, 25.0) - 5.575735e+20*R_pow(x, 27.0) + 2.452774e+21*R_pow(x, 29.0) - 9.114826e+21*R_pow(x, 31.0) + 2.876004e+22*R_pow(x, 33.0) - 7.733792e+22*R_pow(x, 35.0) + 1.776682e+23*R_pow(x, 37.0) - 3.491024e+23*R_pow(x, 39.0) + 5.866623e+23*R_pow(x, 41.0) - 8.419871e+23*R_pow(x, 43.0) + 1.029095e+24*R_pow(x, 45.0) - 1.066223e+24*R_pow(x, 47.0) + 9.302250e+23*R_pow(x, 49.0) - 6.770579e+23*R_pow(x, 51.0) + 4.058416e+23*R_pow(x, 53.0) - 1.967717e+23*R_pow(x, 55.0) + 7.520723e+22*R_pow(x, 57.0) - 2.180175e+22*R_pow(x, 59.0) + 4.503311e+21*R_pow(x, 61.0) - 5.902958e+20*R_pow(x, 63.0) + 3.689349e+19*R_pow(x, 65.0);
    }
    break;
  case 66:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 2.244000e+03*R_pow(x, 2.0) - 8.377600e+05*R_pow(x, 4.0) + 1.246587e+08*R_pow(x, 6.0) - 9.883653e+09*R_pow(x, 8.0) + 4.840794e+11*R_pow(x, 10.0) - 1.601863e+13*R_pow(x, 12.0) + 3.802223e+14*R_pow(x, 14.0) - 6.755284e+15*R_pow(x, 16.0) + 9.271958e+16*R_pow(x, 18.0) - 1.007227e+18*R_pow(x, 20.0) + 8.825231e+18*R_pow(x, 22.0) - 6.331144e+19*R_pow(x, 24.0) + 3.763621e+20*R_pow(x, 26.0) - 1.871854e+21*R_pow(x, 28.0) + 7.848878e+21*R_pow(x, 30.0) - 2.791415e+22*R_pow(x, 32.0) + 8.458834e+22*R_pow(x, 34.0) - 2.191241e+23*R_pow(x, 36.0) + 4.862498e+23*R_pow(x, 38.0) - 9.251214e+23*R_pow(x, 40.0) + 1.508560e+24*R_pow(x, 42.0) - 2.104968e+24*R_pow(x, 44.0) + 2.505623e+24*R_pow(x, 46.0) - 2.532279e+24*R_pow(x, 48.0) + 2.158122e+24*R_pow(x, 50.0) - 1.536401e+24*R_pow(x, 52.0) + 9.018703e+23*R_pow(x, 54.0) - 4.286812e+23*R_pow(x, 56.0) + 1.607879e+23*R_pow(x, 58.0) - 4.578367e+22*R_pow(x, 60.0) + 9.297159e+21*R_pow(x, 62.0) - 1.199038e+21*R_pow(x, 64.0) + 7.378698e+19*R_pow(x, 66.0);
    }
    break;
  case 67:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -6.800000e+01*x + 5.236000e+04*R_pow(x, 3.0) - 1.206374e+07*R_pow(x, 5.0) + 1.317820e+09*R_pow(x, 7.0) - 8.346196e+10*R_pow(x, 9.0) + 3.432563e+12*R_pow(x, 11.0) - 9.857616e+13*R_pow(x, 13.0) + 2.078549e+15*R_pow(x, 15.0) - 3.337905e+16*R_pow(x, 17.0) + 4.196781e+17*R_pow(x, 19.0) - 4.220763e+18*R_pow(x, 21.0) + 3.453351e+19*R_pow(x, 23.0) - 2.329861e+20*R_pow(x, 25.0) + 1.310298e+21*R_pow(x, 27.0) - 6.196482e+21*R_pow(x, 29.0) + 2.481258e+22*R_pow(x, 31.0) - 8.458834e+22*R_pow(x, 33.0) + 2.465146e+23*R_pow(x, 35.0) - 6.159164e+23*R_pow(x, 37.0) + 1.321602e+24*R_pow(x, 39.0) - 2.436905e+24*R_pow(x, 41.0) + 3.859108e+24*R_pow(x, 43.0) - 5.239031e+24*R_pow(x, 45.0) + 6.077470e+24*R_pow(x, 47.0) - 5.994783e+24*R_pow(x, 49.0) + 4.993302e+24*R_pow(x, 51.0) - 3.478643e+24*R_pow(x, 53.0) + 2.000512e+24*R_pow(x, 55.0) - 9.325697e+23*R_pow(x, 57.0) + 3.433775e+23*R_pow(x, 59.0) - 9.607064e+22*R_pow(x, 61.0) + 1.918461e+22*R_pow(x, 63.0) - 2.434970e+21*R_pow(x, 65.0) + 1.475740e+20*R_pow(x, 67.0);
    }
    break;
  case 68:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 2.380000e+03*R_pow(x, 2.0) + 9.424800e+05*R_pow(x, 4.0) - 1.487862e+08*R_pow(x, 6.0) + 1.251929e+10*R_pow(x, 8.0) - 6.510033e+11*R_pow(x, 10.0) + 2.288375e+13*R_pow(x, 12.0) - 5.773747e+14*R_pow(x, 14.0) + 1.091238e+16*R_pow(x, 16.0) - 1.594777e+17*R_pow(x, 18.0) + 1.846584e+18*R_pow(x, 20.0) - 1.726676e+19*R_pow(x, 22.0) + 1.323785e+20*R_pow(x, 24.0) - 8.423343e+20*R_pow(x, 26.0) + 4.492450e+21*R_pow(x, 28.0) - 2.024184e+22*R_pow(x, 30.0) + 7.753932e+22*R_pow(x, 32.0) - 2.537650e+23*R_pow(x, 34.0) + 7.121533e+23*R_pow(x, 36.0) - 1.718083e+24*R_pow(x, 38.0) + 3.568325e+24*R_pow(x, 40.0) - 6.382370e+24*R_pow(x, 42.0) + 9.823183e+24*R_pow(x, 44.0) - 1.298369e+25*R_pow(x, 46.0) + 1.468722e+25*R_pow(x, 48.0) - 1.414769e+25*R_pow(x, 50.0) + 1.152300e+25*R_pow(x, 52.0) - 7.859156e+24*R_pow(x, 54.0) + 4.429706e+24*R_pow(x, 56.0) - 2.025927e+24*R_pow(x, 58.0) + 7.325387e+23*R_pow(x, 60.0) - 2.014384e+23*R_pow(x, 62.0) + 3.956827e+22*R_pow(x, 64.0) - 4.943727e+21*R_pow(x, 66.0) + 2.951479e+20*R_pow(x, 68.0);
    }
    break;
  case 69:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 7.000000e+01*x - 5.712000e+04*R_pow(x, 3.0) + 1.394870e+07*R_pow(x, 5.0) - 1.615393e+09*R_pow(x, 7.0) + 1.085005e+11*R_pow(x, 9.0) - 4.734569e+12*R_pow(x, 11.0) + 1.443437e+14*R_pow(x, 13.0) - 3.233298e+15*R_pow(x, 15.0) + 5.520381e+16*R_pow(x, 17.0) - 7.386334e+17*R_pow(x, 19.0) + 7.913930e+18*R_pow(x, 21.0) - 6.906702e+19*R_pow(x, 23.0) + 4.977430e+20*R_pow(x, 25.0) - 2.994966e+21*R_pow(x, 27.0) + 1.518138e+22*R_pow(x, 29.0) - 6.529627e+22*R_pow(x, 31.0) + 2.396670e+23*R_pow(x, 33.0) - 7.540447e+23*R_pow(x, 35.0) + 2.040223e+24*R_pow(x, 37.0) - 4.757767e+24*R_pow(x, 39.0) + 9.573555e+24*R_pow(x, 41.0) - 1.662385e+25*R_pow(x, 43.0) + 2.488540e+25*R_pow(x, 45.0) - 3.204484e+25*R_pow(x, 47.0) + 3.536922e+25*R_pow(x, 49.0) - 3.328868e+25*R_pow(x, 51.0) + 2.652465e+25*R_pow(x, 53.0) - 1.771882e+25*R_pow(x, 55.0) + 9.791982e+24*R_pow(x, 57.0) - 4.395232e+24*R_pow(x, 59.0) + 1.561148e+24*R_pow(x, 61.0) - 4.220615e+23*R_pow(x, 63.0) + 8.157150e+22*R_pow(x, 65.0) - 1.003503e+22*R_pow(x, 67.0) + 5.902958e+20*R_pow(x, 69.0);
    }
    break;
  case 70:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 2.520000e+03*R_pow(x, 2.0) - 1.056720e+06*R_pow(x, 4.0) + 1.766836e+08*R_pow(x, 6.0) - 1.575008e+10*R_pow(x, 8.0) + 8.680044e+11*R_pow(x, 10.0) - 3.235289e+13*R_pow(x, 12.0) + 8.660620e+14*R_pow(x, 14.0) - 1.737898e+16*R_pow(x, 16.0) + 2.698853e+17*R_pow(x, 18.0) - 3.323850e+18*R_pow(x, 20.0) + 3.309462e+19*R_pow(x, 22.0) - 2.705125e+20*R_pow(x, 24.0) + 1.837820e+21*R_pow(x, 26.0) - 1.048238e+22*R_pow(x, 28.0) + 5.060461e+22*R_pow(x, 30.0) - 2.081318e+23*R_pow(x, 32.0) + 7.330990e+23*R_pow(x, 34.0) - 2.220243e+24*R_pow(x, 36.0) + 5.798528e+24*R_pow(x, 38.0) - 1.308386e+25*R_pow(x, 40.0) + 2.552948e+25*R_pow(x, 42.0) - 4.307088e+25*R_pow(x, 44.0) + 6.275448e+25*R_pow(x, 46.0) - 7.877690e+25*R_pow(x, 48.0) + 8.488613e+25*R_pow(x, 50.0) - 7.810036e+25*R_pow(x, 52.0) + 6.090846e+25*R_pow(x, 54.0) - 3.986735e+25*R_pow(x, 56.0) + 2.160989e+25*R_pow(x, 58.0) - 9.523003e+24*R_pow(x, 60.0) + 3.323734e+24*R_pow(x, 62.0) - 8.836913e+23*R_pow(x, 64.0) + 1.680867e+23*R_pow(x, 66.0) - 2.036521e+22*R_pow(x, 68.0) + 1.180592e+21*R_pow(x, 70.0);
    }
    break;
  case 71:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -7.200000e+01*x + 6.216000e+04*R_pow(x, 3.0) - 1.606214e+07*R_pow(x, 5.0) + 1.968760e+09*R_pow(x, 7.0) - 1.400007e+11*R_pow(x, 9.0) + 6.470578e+12*R_pow(x, 11.0) - 2.090494e+14*R_pow(x, 13.0) + 4.965422e+15*R_pow(x, 15.0) - 8.996177e+16*R_pow(x, 17.0) + 1.278404e+18*R_pow(x, 19.0) - 1.456163e+19*R_pow(x, 21.0) + 1.352563e+20*R_pow(x, 23.0) - 1.038768e+21*R_pow(x, 25.0) + 6.670607e+21*R_pow(x, 27.0) - 3.614615e+22*R_pow(x, 29.0) + 1.665055e+23*R_pow(x, 31.0) - 6.559307e+23*R_pow(x, 33.0) + 2.220243e+24*R_pow(x, 35.0) - 6.480708e+24*R_pow(x, 37.0) + 1.635482e+25*R_pow(x, 39.0) - 3.574127e+25*R_pow(x, 41.0) + 6.768281e+25*R_pow(x, 43.0) - 1.110272e+26*R_pow(x, 45.0) + 1.575538e+26*R_pow(x, 47.0) - 1.929230e+26*R_pow(x, 49.0) + 2.030609e+26*R_pow(x, 51.0) - 1.827254e+26*R_pow(x, 53.0) + 1.395357e+26*R_pow(x, 55.0) - 8.952669e+25*R_pow(x, 57.0) + 4.761501e+25*R_pow(x, 59.0) - 2.060715e+25*R_pow(x, 61.0) + 7.069530e+24*R_pow(x, 63.0) - 1.848954e+24*R_pow(x, 65.0) + 3.462085e+23*R_pow(x, 67.0) - 4.132071e+22*R_pow(x, 69.0) + 2.361183e+21*R_pow(x, 71.0);
    }
    break;
  case 72:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 2.664000e+03*R_pow(x, 2.0) + 1.181040e+06*R_pow(x, 4.0) - 2.088079e+08*R_pow(x, 6.0) + 1.968760e+10*R_pow(x, 8.0) - 1.148006e+12*R_pow(x, 10.0) + 4.529405e+13*R_pow(x, 12.0) - 1.284161e+15*R_pow(x, 14.0) + 2.730982e+16*R_pow(x, 16.0) - 4.498088e+17*R_pow(x, 18.0) + 5.880659e+18*R_pow(x, 20.0) - 6.221788e+19*R_pow(x, 22.0) + 5.410250e+20*R_pow(x, 24.0) - 3.915356e+21*R_pow(x, 26.0) + 2.382360e+22*R_pow(x, 28.0) - 1.228969e+23*R_pow(x, 30.0) + 5.411428e+23*R_pow(x, 32.0) - 2.044960e+24*R_pow(x, 34.0) + 6.660728e+24*R_pow(x, 36.0) - 1.875995e+25*R_pow(x, 38.0) + 4.579351e+25*R_pow(x, 40.0) - 9.701203e+25*R_pow(x, 42.0) + 1.784365e+26*R_pow(x, 44.0) - 2.848088e+26*R_pow(x, 46.0) + 3.938845e+26*R_pow(x, 48.0) - 4.707322e+26*R_pow(x, 50.0) + 4.842222e+26*R_pow(x, 52.0) - 4.263592e+26*R_pow(x, 54.0) + 3.189388e+26*R_pow(x, 56.0) - 2.006633e+26*R_pow(x, 58.0) + 1.047530e+26*R_pow(x, 60.0) - 4.453804e+25*R_pow(x, 62.0) + 1.502275e+25*R_pow(x, 64.0) - 3.865995e+24*R_pow(x, 66.0) + 7.127822e+23*R_pow(x, 68.0) - 8.382201e+22*R_pow(x, 70.0) + 4.722366e+21*R_pow(x, 72.0);
    }
    break;
  case 73:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 7.400000e+01*x - 6.748800e+04*R_pow(x, 3.0) + 1.842422e+07*R_pow(x, 5.0) - 2.386376e+09*R_pow(x, 7.0) + 1.793759e+11*R_pow(x, 9.0) - 8.766590e+12*R_pow(x, 11.0) + 2.996375e+14*R_pow(x, 13.0) - 7.533744e+15*R_pow(x, 15.0) + 1.445814e+17*R_pow(x, 17.0) - 2.178022e+18*R_pow(x, 19.0) + 2.632295e+19*R_pow(x, 21.0) - 2.596920e+20*R_pow(x, 23.0) + 2.120818e+21*R_pow(x, 25.0) - 1.450132e+22*R_pow(x, 27.0) + 8.379334e+22*R_pow(x, 29.0) - 4.122993e+23*R_pow(x, 31.0) + 1.738216e+24*R_pow(x, 33.0) - 6.310163e+24*R_pow(x, 35.0) + 1.980216e+25*R_pow(x, 37.0) - 5.387471e+25*R_pow(x, 39.0) + 1.273283e+26*R_pow(x, 41.0) - 2.617069e+26*R_pow(x, 43.0) + 4.679002e+26*R_pow(x, 45.0) - 7.271714e+26*R_pow(x, 47.0) + 9.806920e+26*R_pow(x, 49.0) - 1.144525e+27*R_pow(x, 51.0) + 1.151170e+27*R_pow(x, 53.0) - 9.922541e+26*R_pow(x, 55.0) + 7.274043e+26*R_pow(x, 57.0) - 4.489415e+26*R_pow(x, 59.0) + 2.301132e+26*R_pow(x, 61.0) - 9.614561e+25*R_pow(x, 63.0) + 3.189446e+25*R_pow(x, 65.0) - 8.078198e+24*R_pow(x, 67.0) + 1.466885e+24*R_pow(x, 69.0) - 1.700052e+23*R_pow(x, 71.0) + 9.444733e+21*R_pow(x, 73.0);
    }
    break;
  case 74:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 2.812000e+03*R_pow(x, 2.0) - 1.316016e+06*R_pow(x, 4.0) + 2.456563e+08*R_pow(x, 6.0) - 2.446035e+10*R_pow(x, 8.0) + 1.506758e+12*R_pow(x, 10.0) - 6.282723e+13*R_pow(x, 12.0) + 1.883436e+15*R_pow(x, 14.0) - 4.237731e+16*R_pow(x, 16.0) + 7.389716e+17*R_pow(x, 18.0) - 1.023670e+19*R_pow(x, 20.0) + 1.148638e+20*R_pow(x, 22.0) - 1.060409e+21*R_pow(x, 24.0) + 8.156992e+21*R_pow(x, 26.0) - 5.282624e+22*R_pow(x, 28.0) + 2.904836e+23*R_pow(x, 30.0) - 1.365741e+24*R_pow(x, 32.0) + 5.521393e+24*R_pow(x, 34.0) - 1.928105e+25*R_pow(x, 36.0) + 5.836427e+25*R_pow(x, 38.0) - 1.535429e+26*R_pow(x, 40.0) + 3.516686e+26*R_pow(x, 42.0) - 7.018502e+26*R_pow(x, 44.0) + 1.220609e+27*R_pow(x, 46.0) - 1.848227e+27*R_pow(x, 48.0) + 2.432116e+27*R_pow(x, 50.0) - 2.773273e+27*R_pow(x, 52.0) + 2.728699e+27*R_pow(x, 54.0) - 2.303447e+27*R_pow(x, 56.0) + 1.655472e+27*R_pow(x, 58.0) - 1.002636e+27*R_pow(x, 60.0) + 5.047645e+26*R_pow(x, 62.0) - 2.073140e+26*R_pow(x, 64.0) + 6.765491e+25*R_pow(x, 66.0) - 1.686918e+25*R_pow(x, 68.0) + 3.017592e+24*R_pow(x, 70.0) - 3.447328e+23*R_pow(x, 72.0) + 1.888947e+22*R_pow(x, 74.0);
    }
    break;
  case 75:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -7.600000e+01*x + 7.311200e+04*R_pow(x, 3.0) - 2.105626e+07*R_pow(x, 5.0) + 2.877688e+09*R_pow(x, 7.0) - 2.282966e+11*R_pow(x, 9.0) + 1.178010e+13*R_pow(x, 11.0) - 4.252920e+14*R_pow(x, 13.0) + 1.130062e+16*R_pow(x, 15.0) - 2.293360e+17*R_pow(x, 17.0) + 3.655965e+18*R_pow(x, 19.0) - 4.679635e+19*R_pow(x, 21.0) + 4.894195e+20*R_pow(x, 23.0) - 4.241636e+21*R_pow(x, 25.0) + 3.081530e+22*R_pow(x, 27.0) - 1.894458e+23*R_pow(x, 29.0) + 9.932664e+23*R_pow(x, 31.0) - 4.469699e+24*R_pow(x, 33.0) + 1.735295e+25*R_pow(x, 35.0) - 5.836427e+25*R_pow(x, 37.0) + 1.706033e+26*R_pow(x, 39.0) - 4.344142e+26*R_pow(x, 41.0) + 9.650441e+26*R_pow(x, 43.0) - 1.871601e+27*R_pow(x, 45.0) + 3.168390e+27*R_pow(x, 47.0) - 4.677147e+27*R_pow(x, 49.0) + 6.008758e+27*R_pow(x, 51.0) - 6.697715e+27*R_pow(x, 53.0) + 6.449652e+27*R_pow(x, 55.0) - 5.334299e+27*R_pow(x, 57.0) + 3.759885e+27*R_pow(x, 59.0) - 2.235385e+27*R_pow(x, 61.0) + 1.105675e+27*R_pow(x, 63.0) - 4.465224e+26*R_pow(x, 65.0) + 1.433880e+26*R_pow(x, 67.0) - 3.520524e+25*R_pow(x, 69.0) + 6.205190e+24*R_pow(x, 71.0) - 6.989102e+23*R_pow(x, 73.0) + 3.777893e+22*R_pow(x, 75.0);
    }
    break;
  case 76:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 2.964000e+03*R_pow(x, 2.0) + 1.462240e+06*R_pow(x, 4.0) - 2.877688e+08*R_pow(x, 6.0) + 3.021573e+10*R_pow(x, 8.0) - 1.963351e+12*R_pow(x, 10.0) + 8.638744e+13*R_pow(x, 12.0) - 2.734020e+15*R_pow(x, 14.0) + 6.497854e+16*R_pow(x, 16.0) - 1.197644e+18*R_pow(x, 18.0) + 1.754863e+19*R_pow(x, 20.0) - 2.084565e+20*R_pow(x, 22.0) + 2.039248e+21*R_pow(x, 24.0) - 1.664026e+22*R_pow(x, 26.0) + 1.144568e+23*R_pow(x, 28.0) - 6.693752e+23*R_pow(x, 30.0) + 3.352274e+24*R_pow(x, 32.0) - 1.446079e+25*R_pow(x, 34.0) + 5.398695e+25*R_pow(x, 36.0) - 1.750928e+26*R_pow(x, 38.0) + 4.947495e+26*R_pow(x, 40.0) - 1.220497e+27*R_pow(x, 42.0) + 2.631938e+27*R_pow(x, 44.0) - 4.963810e+27*R_pow(x, 46.0) + 8.185006e+27*R_pow(x, 48.0) - 1.178641e+28*R_pow(x, 50.0) + 1.479079e+28*R_pow(x, 52.0) - 1.612413e+28*R_pow(x, 54.0) + 1.520275e+28*R_pow(x, 56.0) - 1.232407e+28*R_pow(x, 58.0) + 8.522407e+27*R_pow(x, 60.0) - 4.975535e+27*R_pow(x, 62.0) + 2.418663e+27*R_pow(x, 64.0) - 9.606997e+26*R_pow(x, 66.0) + 3.036452e+26*R_pow(x, 68.0) - 7.342808e+25*R_pow(x, 70.0) + 1.275511e+25*R_pow(x, 72.0) - 1.416710e+24*R_pow(x, 74.0) + 7.555786e+22*R_pow(x, 76.0);
    }
    break;
  case 77:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 7.800000e+01*x - 7.904000e+04*R_pow(x, 3.0) + 2.398074e+07*R_pow(x, 5.0) - 3.453226e+09*R_pow(x, 7.0) + 2.887281e+11*R_pow(x, 9.0) - 1.570681e+13*R_pow(x, 11.0) + 5.980669e+14*R_pow(x, 13.0) - 1.676866e+16*R_pow(x, 15.0) + 3.592931e+17*R_pow(x, 17.0) - 6.051252e+18*R_pow(x, 19.0) + 8.189362e+19*R_pow(x, 21.0) - 9.063325e+20*R_pow(x, 23.0) + 8.320132e+21*R_pow(x, 25.0) - 6.409583e+22*R_pow(x, 27.0) + 4.183595e+23*R_pow(x, 29.0) - 2.332017e+24*R_pow(x, 31.0) + 1.117425e+25*R_pow(x, 33.0) - 4.627453e+25*R_pow(x, 35.0) + 1.663382e+26*R_pow(x, 37.0) - 5.207889e+26*R_pow(x, 39.0) + 1.423913e+27*R_pow(x, 41.0) - 3.406038e+27*R_pow(x, 43.0) + 7.135477e+27*R_pow(x, 45.0) - 1.309601e+28*R_pow(x, 47.0) + 2.104716e+28*R_pow(x, 49.0) - 2.958158e+28*R_pow(x, 51.0) + 3.627929e+28*R_pow(x, 53.0) - 3.869791e+28*R_pow(x, 55.0) + 3.573980e+28*R_pow(x, 57.0) - 2.840802e+28*R_pow(x, 59.0) + 1.928020e+28*R_pow(x, 61.0) - 1.105675e+28*R_pow(x, 63.0) + 5.283848e+27*R_pow(x, 65.0) - 2.064787e+27*R_pow(x, 67.0) + 6.424957e+26*R_pow(x, 69.0) - 1.530613e+26*R_pow(x, 71.0) + 2.620913e+25*R_pow(x, 73.0) - 2.871199e+24*R_pow(x, 75.0) + 1.511157e+23*R_pow(x, 77.0);
    }
    break;
  case 78:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 3.120000e+03*R_pow(x, 2.0) - 1.620320e+06*R_pow(x, 4.0) + 3.357303e+08*R_pow(x, 6.0) - 3.712218e+10*R_pow(x, 8.0) + 2.540807e+12*R_pow(x, 10.0) - 1.178010e+14*R_pow(x, 12.0) + 3.930154e+15*R_pow(x, 14.0) - 9.851585e+16*R_pow(x, 16.0) + 1.916230e+18*R_pow(x, 18.0) - 2.965114e+19*R_pow(x, 20.0) + 3.722437e+20*R_pow(x, 22.0) - 3.851913e+21*R_pow(x, 24.0) + 3.328053e+22*R_pow(x, 26.0) - 2.426485e+23*R_pow(x, 28.0) + 1.506094e+24*R_pow(x, 30.0) - 8.016308e+24*R_pow(x, 32.0) + 3.680929e+25*R_pow(x, 34.0) - 1.465360e+26*R_pow(x, 36.0) + 5.077692e+26*R_pow(x, 38.0) - 1.536327e+27*R_pow(x, 40.0) + 4.068323e+27*R_pow(x, 42.0) - 9.444014e+27*R_pow(x, 44.0) + 1.923477e+28*R_pow(x, 46.0) - 3.437703e+28*R_pow(x, 48.0) + 5.388073e+28*R_pow(x, 50.0) - 7.395394e+28*R_pow(x, 52.0) + 8.868271e+28*R_pow(x, 54.0) - 9.259857e+28*R_pow(x, 56.0) + 8.380367e+28*R_pow(x, 58.0) - 6.533845e+28*R_pow(x, 60.0) + 4.353593e+28*R_pow(x, 62.0) - 2.453215e+28*R_pow(x, 64.0) + 1.152840e+28*R_pow(x, 66.0) - 4.433220e+27*R_pow(x, 68.0) + 1.358419e+27*R_pow(x, 70.0) - 3.188778e+26*R_pow(x, 72.0) + 5.383498e+25*R_pow(x, 74.0) - 5.817956e+24*R_pow(x, 76.0) + 3.022315e+23*R_pow(x, 78.0);
    }
    break;
  case 79:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -8.000000e+01*x + 8.528000e+04*R_pow(x, 3.0) - 2.722138e+07*R_pow(x, 5.0) + 4.124687e+09*R_pow(x, 7.0) - 3.629724e+11*R_pow(x, 9.0) + 2.078842e+13*R_pow(x, 11.0) - 8.336690e+14*R_pow(x, 13.0) + 2.462896e+16*R_pow(x, 15.0) - 5.563248e+17*R_pow(x, 17.0) + 9.883712e+18*R_pow(x, 19.0) - 1.411959e+20*R_pow(x, 21.0) + 1.650820e+21*R_pow(x, 23.0) - 1.602396e+22*R_pow(x, 25.0) + 1.306569e+23*R_pow(x, 27.0) - 9.036565e+23*R_pow(x, 29.0) + 5.344205e+24*R_pow(x, 31.0) - 2.720686e+25*R_pow(x, 33.0) + 1.198931e+26*R_pow(x, 35.0) - 4.594102e+26*R_pow(x, 37.0) + 1.536327e+27*R_pow(x, 39.0) - 4.496568e+27*R_pow(x, 41.0) + 1.154268e+28*R_pow(x, 43.0) - 2.602351e+28*R_pow(x, 45.0) + 5.156554e+28*R_pow(x, 47.0) - 8.980121e+28*R_pow(x, 49.0) + 1.373430e+29*R_pow(x, 51.0) - 1.841872e+29*R_pow(x, 53.0) + 2.160633e+29*R_pow(x, 55.0) - 2.209369e+29*R_pow(x, 57.0) + 1.960154e+29*R_pow(x, 59.0) - 1.499571e+29*R_pow(x, 61.0) + 9.812861e+28*R_pow(x, 63.0) - 5.434816e+28*R_pow(x, 65.0) + 2.512158e+28*R_pow(x, 67.0) - 9.508936e+27*R_pow(x, 69.0) + 2.869900e+27*R_pow(x, 71.0) - 6.639647e+26*R_pow(x, 73.0) + 1.105412e+26*R_pow(x, 75.0) - 1.178703e+25*R_pow(x, 77.0) + 6.044629e+23*R_pow(x, 79.0);
    }
    break;
  case 80:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 3.280000e+03*R_pow(x, 2.0) + 1.790880e+06*R_pow(x, 4.0) - 3.901731e+08*R_pow(x, 6.0) + 4.537155e+10*R_pow(x, 8.0) - 3.266752e+12*R_pow(x, 10.0) + 1.593779e+14*R_pow(x, 12.0) - 5.597492e+15*R_pow(x, 14.0) + 1.477738e+17*R_pow(x, 16.0) - 3.028880e+18*R_pow(x, 18.0) + 4.941856e+19*R_pow(x, 20.0) - 6.546355e+20*R_pow(x, 22.0) + 7.153553e+21*R_pow(x, 24.0) - 6.532845e+22*R_pow(x, 26.0) + 5.039623e+23*R_pow(x, 28.0) - 3.313407e+24*R_pow(x, 30.0) + 1.870472e+25*R_pow(x, 32.0) - 9.122301e+25*R_pow(x, 34.0) + 3.863222e+26*R_pow(x, 36.0) - 1.426590e+27*R_pow(x, 38.0) + 4.608982e+27*R_pow(x, 40.0) - 1.306146e+28*R_pow(x, 42.0) + 3.252938e+28*R_pow(x, 44.0) - 7.128178e+28*R_pow(x, 46.0) + 1.375081e+29*R_pow(x, 48.0) - 2.334832e+29*R_pow(x, 50.0) + 3.486400e+29*R_pow(x, 52.0) - 4.570571e+29*R_pow(x, 54.0) + 5.247252e+29*R_pow(x, 56.0) - 5.256776e+29*R_pow(x, 58.0) + 4.573692e+29*R_pow(x, 60.0) - 3.434501e+29*R_pow(x, 62.0) + 2.207894e+29*R_pow(x, 64.0) - 1.202247e+29*R_pow(x, 66.0) + 5.467638e+28*R_pow(x, 68.0) - 2.037629e+28*R_pow(x, 70.0) + 6.058678e+27*R_pow(x, 72.0) - 1.381764e+27*R_pow(x, 74.0) + 2.269003e+26*R_pow(x, 76.0) - 2.387628e+25*R_pow(x, 78.0) + 1.208926e+24*R_pow(x, 80.0);
    }
    break;
  case 81:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 8.200000e+01*x - 9.184000e+04*R_pow(x, 3.0) + 3.080314e+07*R_pow(x, 5.0) - 4.905033e+09*R_pow(x, 7.0) + 4.537155e+11*R_pow(x, 9.0) - 2.732192e+13*R_pow(x, 11.0) + 1.152425e+15*R_pow(x, 13.0) - 3.582395e+16*R_pow(x, 15.0) + 8.518724e+17*R_pow(x, 17.0) - 1.594147e+19*R_pow(x, 19.0) + 2.400330e+20*R_pow(x, 21.0) - 2.960091e+21*R_pow(x, 23.0) + 3.033106e+22*R_pow(x, 25.0) - 2.613138e+23*R_pow(x, 27.0) + 1.911581e+24*R_pow(x, 29.0) - 1.197102e+25*R_pow(x, 31.0) + 6.461630e+25*R_pow(x, 33.0) - 3.023391e+26*R_pow(x, 35.0) + 1.232055e+27*R_pow(x, 37.0) - 4.389506e+27*R_pow(x, 39.0) + 1.371453e+28*R_pow(x, 41.0) - 3.766560e+28*R_pow(x, 43.0) + 9.108227e+28*R_pow(x, 45.0) - 1.941291e+29*R_pow(x, 47.0) + 3.648174e+29*R_pow(x, 49.0) - 6.043093e+29*R_pow(x, 51.0) + 8.814672e+29*R_pow(x, 53.0) - 1.130177e+30*R_pow(x, 55.0) + 1.270387e+30*R_pow(x, 57.0) - 1.247370e+30*R_pow(x, 59.0) + 1.064695e+30*R_pow(x, 61.0) - 7.850289e+29*R_pow(x, 63.0) + 4.959269e+29*R_pow(x, 65.0) - 2.655710e+29*R_pow(x, 67.0) + 1.188617e+29*R_pow(x, 69.0) - 4.362248e+28*R_pow(x, 71.0) + 1.278132e+28*R_pow(x, 73.0) - 2.874070e+27*R_pow(x, 75.0) + 4.655876e+26*R_pow(x, 77.0) - 4.835703e+25*R_pow(x, 79.0) + 2.417852e+24*R_pow(x, 81.0);
    }
    break;
  case 82:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 3.444000e+03*R_pow(x, 2.0) - 1.974560e+06*R_pow(x, 4.0) + 4.517793e+08*R_pow(x, 6.0) - 5.518162e+10*R_pow(x, 8.0) + 4.174183e+12*R_pow(x, 10.0) - 2.140217e+14*R_pow(x, 12.0) + 7.902341e+15*R_pow(x, 14.0) - 2.194217e+17*R_pow(x, 16.0) + 4.732624e+18*R_pow(x, 18.0) - 8.130150e+19*R_pow(x, 20.0) + 1.134702e+21*R_pow(x, 22.0) - 1.307373e+22*R_pow(x, 24.0) + 1.259906e+23*R_pow(x, 26.0) - 1.026590e+24*R_pow(x, 28.0) + 7.136570e+24*R_pow(x, 30.0) - 4.264676e+25*R_pow(x, 32.0) + 2.204556e+26*R_pow(x, 34.0) - 9.910005e+26*R_pow(x, 36.0) + 3.890699e+27*R_pow(x, 38.0) - 1.338799e+28*R_pow(x, 40.0) + 4.049052e+28*R_pow(x, 42.0) - 1.078606e+29*R_pow(x, 44.0) + 2.534463e+29*R_pow(x, 46.0) - 5.257663e+29*R_pow(x, 48.0) + 9.631180e+29*R_pow(x, 50.0) - 1.557259e+30*R_pow(x, 52.0) + 2.219991e+30*R_pow(x, 54.0) - 2.785080e+30*R_pow(x, 56.0) + 3.066452e+30*R_pow(x, 58.0) - 2.952110e+30*R_pow(x, 60.0) + 2.472841e+30*R_pow(x, 62.0) - 1.790847e+30*R_pow(x, 64.0) + 1.112079e+30*R_pow(x, 66.0) - 5.858184e+29*R_pow(x, 68.0) + 2.580997e+29*R_pow(x, 70.0) - 9.330364e+28*R_pow(x, 72.0) + 2.694441e+28*R_pow(x, 74.0) - 5.975040e+27*R_pow(x, 76.0) + 9.550514e+26*R_pow(x, 78.0) - 9.792299e+25*R_pow(x, 80.0) + 4.835703e+24*R_pow(x, 82.0);
    }
    break;
  case 83:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -8.400000e+01*x + 9.872800e+04*R_pow(x, 3.0) - 3.475226e+07*R_pow(x, 5.0) + 5.808591e+09*R_pow(x, 7.0) - 5.640788e+11*R_pow(x, 9.0) + 3.567029e+13*R_pow(x, 11.0) - 1.580468e+15*R_pow(x, 13.0) + 5.162863e+16*R_pow(x, 15.0) - 1.290716e+18*R_pow(x, 17.0) + 2.540672e+19*R_pow(x, 19.0) - 4.026360e+20*R_pow(x, 21.0) + 5.229494e+21*R_pow(x, 23.0) - 5.647853e+22*R_pow(x, 25.0) + 5.132949e+23*R_pow(x, 27.0) - 3.964761e+24*R_pow(x, 29.0) + 2.624416e+25*R_pow(x, 31.0) - 1.499098e+26*R_pow(x, 33.0) + 7.432504e+26*R_pow(x, 35.0) - 3.214056e+27*R_pow(x, 37.0) + 1.217090e+28*R_pow(x, 39.0) - 4.049052e+28*R_pow(x, 41.0) + 1.186466e+29*R_pow(x, 43.0) - 3.068034e+29*R_pow(x, 45.0) + 7.010217e+29*R_pow(x, 47.0) - 1.416350e+30*R_pow(x, 49.0) + 2.530545e+30*R_pow(x, 51.0) - 3.995985e+30*R_pow(x, 53.0) + 5.570160e+30*R_pow(x, 55.0) - 6.840548e+30*R_pow(x, 57.0) + 7.380275e+30*R_pow(x, 59.0) - 6.968916e+30*R_pow(x, 61.0) + 5.730711e+30*R_pow(x, 63.0) - 4.077621e+30*R_pow(x, 65.0) + 2.489728e+30*R_pow(x, 67.0) - 1.290498e+30*R_pow(x, 69.0) + 5.598219e+29*R_pow(x, 71.0) - 1.993886e+29*R_pow(x, 73.0) + 5.676288e+28*R_pow(x, 75.0) - 1.241567e+28*R_pow(x, 77.0) + 1.958460e+27*R_pow(x, 79.0) - 1.982638e+26*R_pow(x, 81.0) + 9.671407e+24*R_pow(x, 83.0);
    }
    break;
  case 84:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 3.612000e+03*R_pow(x, 2.0) + 2.172016e+06*R_pow(x, 4.0) - 5.212838e+08*R_pow(x, 6.0) + 6.679880e+10*R_pow(x, 8.0) - 5.302340e+12*R_pow(x, 10.0) + 2.853623e+14*R_pow(x, 12.0) - 1.106328e+16*R_pow(x, 14.0) + 3.226789e+17*R_pow(x, 16.0) - 7.314056e+18*R_pow(x, 18.0) + 1.321149e+20*R_pow(x, 20.0) - 1.939974e+21*R_pow(x, 22.0) + 2.353272e+22*R_pow(x, 24.0) - 2.389476e+23*R_pow(x, 26.0) + 2.053180e+24*R_pow(x, 28.0) - 1.506609e+25*R_pow(x, 30.0) + 9.513508e+25*R_pow(x, 32.0) - 5.202753e+26*R_pow(x, 34.0) + 2.477501e+27*R_pow(x, 36.0) - 1.031881e+28*R_pow(x, 38.0) + 3.772980e+28*R_pow(x, 40.0) - 1.214716e+29*R_pow(x, 42.0) + 3.451539e+29*R_pow(x, 44.0) - 8.670532e+29*R_pow(x, 46.0) + 1.927810e+30*R_pow(x, 48.0) - 3.795818e+30*R_pow(x, 50.0) + 6.618349e+30*R_pow(x, 52.0) - 1.021196e+31*R_pow(x, 54.0) + 1.392540e+31*R_pow(x, 56.0) - 1.674755e+31*R_pow(x, 58.0) + 1.771266e+31*R_pow(x, 60.0) - 1.641067e+31*R_pow(x, 62.0) + 1.325227e+31*R_pow(x, 64.0) - 9.267321e+30*R_pow(x, 66.0) + 5.565275e+30*R_pow(x, 68.0) - 2.839097e+30*R_pow(x, 70.0) + 1.212947e+30*R_pow(x, 72.0) - 4.257216e+29*R_pow(x, 74.0) + 1.195008e+29*R_pow(x, 76.0) - 2.578639e+28*R_pow(x, 78.0) + 4.014843e+27*R_pow(x, 80.0) - 4.013634e+26*R_pow(x, 82.0) + 1.934281e+25*R_pow(x, 84.0);
    }
    break;
  case 85:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 8.600000e+01*x - 1.059520e+05*R_pow(x, 3.0) + 3.909629e+07*R_pow(x, 5.0) - 6.851159e+09*R_pow(x, 7.0) + 6.976764e+11*R_pow(x, 9.0) - 4.627497e+13*R_pow(x, 11.0) + 2.151193e+15*R_pow(x, 13.0) - 7.375518e+16*R_pow(x, 15.0) + 1.936074e+18*R_pow(x, 17.0) - 4.003483e+19*R_pow(x, 19.0) + 6.668659e+20*R_pow(x, 21.0) - 9.109441e+21*R_pow(x, 23.0) + 1.035440e+23*R_pow(x, 25.0) - 9.911902e+23*R_pow(x, 27.0) + 8.071120e+24*R_pow(x, 29.0) - 5.637634e+25*R_pow(x, 31.0) + 3.401800e+26*R_pow(x, 33.0) - 1.783801e+27*R_pow(x, 35.0) + 8.169058e+27*R_pow(x, 37.0) - 3.280852e+28*R_pow(x, 39.0) + 1.159501e+29*R_pow(x, 41.0) - 3.615898e+29*R_pow(x, 43.0) + 9.971112e+29*R_pow(x, 45.0) - 2.435128e+30*R_pow(x, 47.0) + 5.271970e+30*R_pow(x, 49.0) - 1.012218e+31*R_pow(x, 51.0) + 1.723268e+31*R_pow(x, 53.0) - 2.599408e+31*R_pow(x, 55.0) + 3.469135e+31*R_pow(x, 57.0) - 4.087537e+31*R_pow(x, 59.0) + 4.239424e+31*R_pow(x, 61.0) - 3.855206e+31*R_pow(x, 63.0) + 3.058216e+31*R_pow(x, 65.0) - 2.102437e+31*R_pow(x, 67.0) + 1.242105e+31*R_pow(x, 69.0) - 6.238015e+30*R_pow(x, 71.0) + 2.625283e+30*R_pow(x, 73.0) - 9.082061e+29*R_pow(x, 75.0) + 2.514173e+29*R_pow(x, 77.0) - 5.353124e+28*R_pow(x, 79.0) + 8.227949e+27*R_pow(x, 81.0) - 8.123982e+26*R_pow(x, 83.0) + 3.868563e+25*R_pow(x, 85.0);
    }
    break;
  case 86:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 3.784000e+03*R_pow(x, 2.0) - 2.383920e+06*R_pow(x, 4.0) + 5.994764e+08*R_pow(x, 6.0) - 8.050112e+10*R_pow(x, 8.0) + 6.697693e+12*R_pow(x, 10.0) - 3.779123e+14*R_pow(x, 12.0) + 1.536566e+16*R_pow(x, 14.0) - 4.701893e+17*R_pow(x, 16.0) + 1.118620e+19*R_pow(x, 18.0) - 2.121846e+20*R_pow(x, 20.0) + 3.273705e+21*R_pow(x, 22.0) - 4.175160e+22*R_pow(x, 24.0) + 4.460356e+23*R_pow(x, 26.0) - 4.035560e+24*R_pow(x, 28.0) + 3.120833e+25*R_pow(x, 30.0) - 2.078878e+26*R_pow(x, 32.0) + 1.200635e+27*R_pow(x, 34.0) - 6.045103e+27*R_pow(x, 36.0) + 2.665693e+28*R_pow(x, 38.0) - 1.033469e+29*R_pow(x, 40.0) + 3.533718e+29*R_pow(x, 42.0) - 1.068333e+30*R_pow(x, 44.0) + 2.861276e+30*R_pow(x, 46.0) - 6.798066e+30*R_pow(x, 48.0) + 1.433976e+31*R_pow(x, 50.0) - 2.686271e+31*R_pow(x, 52.0) + 4.467733e+31*R_pow(x, 54.0) - 6.591356e+31*R_pow(x, 56.0) + 8.613025e+31*R_pow(x, 58.0) - 9.946340e+31*R_pow(x, 60.0) + 1.011991e+32*R_pow(x, 62.0) - 9.035638e+31*R_pow(x, 64.0) + 7.043164e+31*R_pow(x, 66.0) - 4.761402e+31*R_pow(x, 68.0) + 2.768119e+31*R_pow(x, 70.0) - 1.368898e+31*R_pow(x, 72.0) + 5.676288e+30*R_pow(x, 74.0) - 1.935913e+30*R_pow(x, 76.0) + 5.286209e+29*R_pow(x, 78.0) - 1.110773e+29*R_pow(x, 80.0) + 1.685726e+28*R_pow(x, 82.0) - 1.644139e+27*R_pow(x, 84.0) + 7.737125e+25*R_pow(x, 86.0);
    }
    break;
  case 87:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -8.800000e+01*x + 1.135200e+05*R_pow(x, 3.0) - 4.386413e+07*R_pow(x, 5.0) + 8.050112e+09*R_pow(x, 7.0) - 8.586786e+11*R_pow(x, 9.0) + 5.967036e+13*R_pow(x, 11.0) - 2.907017e+15*R_pow(x, 13.0) + 1.044865e+17*R_pow(x, 15.0) - 2.876452e+18*R_pow(x, 17.0) + 6.240724e+19*R_pow(x, 19.0) - 1.091235e+21*R_pow(x, 21.0) + 1.565685e+22*R_pow(x, 23.0) - 1.870472e+23*R_pow(x, 25.0) + 1.883261e+24*R_pow(x, 27.0) - 1.614224e+25*R_pow(x, 29.0) + 1.187930e+26*R_pow(x, 31.0) - 7.559555e+26*R_pow(x, 33.0) + 4.185071e+27*R_pow(x, 35.0) - 2.025926e+28*R_pow(x, 37.0) + 8.612238e+28*R_pow(x, 39.0) - 3.226438e+29*R_pow(x, 41.0) + 1.068333e+30*R_pow(x, 43.0) - 3.133778e+30*R_pow(x, 45.0) + 8.157679e+30*R_pow(x, 47.0) - 1.886810e+31*R_pow(x, 49.0) + 3.880170e+31*R_pow(x, 51.0) - 7.095811e+31*R_pow(x, 53.0) + 1.153487e+32*R_pow(x, 55.0) - 1.665185e+32*R_pow(x, 57.0) + 2.131359e+32*R_pow(x, 59.0) - 2.413210e+32*R_pow(x, 61.0) + 2.409504e+32*R_pow(x, 63.0) - 2.112949e+32*R_pow(x, 65.0) + 1.618877e+32*R_pow(x, 67.0) - 1.076491e+32*R_pow(x, 69.0) + 6.160040e+31*R_pow(x, 71.0) - 3.000324e+31*R_pow(x, 73.0) + 1.226078e+31*R_pow(x, 75.0) - 4.123243e+30*R_pow(x, 77.0) + 1.110773e+30*R_pow(x, 79.0) - 2.303826e+29*R_pow(x, 81.0) + 3.452692e+28*R_pow(x, 83.0) - 3.326964e+27*R_pow(x, 85.0) + 1.547425e+26*R_pow(x, 87.0);
    }
    break;
  case 88:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 3.960000e+03*R_pow(x, 2.0) + 2.610960e+06*R_pow(x, 4.0) - 6.872047e+08*R_pow(x, 6.0) + 9.660134e+10*R_pow(x, 8.0) - 8.415050e+12*R_pow(x, 10.0) + 4.972530e+14*R_pow(x, 12.0) - 2.117970e+16*R_pow(x, 14.0) + 6.791623e+17*R_pow(x, 16.0) - 1.693911e+19*R_pow(x, 18.0) + 3.369991e+20*R_pow(x, 20.0) - 5.456176e+21*R_pow(x, 22.0) + 7.306531e+22*R_pow(x, 24.0) - 8.201300e+23*R_pow(x, 26.0) + 7.802083e+24*R_pow(x, 28.0) - 6.349281e+25*R_pow(x, 30.0) + 4.454738e+26*R_pow(x, 32.0) - 2.712546e+27*R_pow(x, 34.0) + 1.441525e+28*R_pow(x, 36.0) - 6.717545e+28*R_pow(x, 38.0) + 2.755916e+29*R_pow(x, 40.0) - 9.986595e+29*R_pow(x, 42.0) + 3.205000e+30*R_pow(x, 44.0) - 9.128831e+30*R_pow(x, 46.0) + 2.311342e+31*R_pow(x, 48.0) - 5.207596e+31*R_pow(x, 50.0) + 1.044661e+32*R_pow(x, 52.0) - 1.865935e+32*R_pow(x, 54.0) + 2.966110e+32*R_pow(x, 56.0) - 4.191672e+32*R_pow(x, 58.0) + 5.257351e+32*R_pow(x, 60.0) - 5.838412e+32*R_pow(x, 62.0) + 5.722571e+32*R_pow(x, 64.0) - 4.930215e+32*R_pow(x, 66.0) + 3.713893e+32*R_pow(x, 68.0) - 2.429793e+32*R_pow(x, 70.0) + 1.368898e+32*R_pow(x, 72.0) - 6.568276e+31*R_pow(x, 74.0) + 2.645748e+31*R_pow(x, 76.0) - 8.775108e+30*R_pow(x, 78.0) + 2.332624e+30*R_pow(x, 80.0) - 4.776224e+29*R_pow(x, 82.0) + 7.069798e+28*R_pow(x, 84.0) - 6.731299e+27*R_pow(x, 86.0) + 3.094850e+26*R_pow(x, 88.0);
    }
    break;
  case 89:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 9.000000e+01*x - 1.214400e+05*R_pow(x, 3.0) + 4.908605e+07*R_pow(x, 5.0) - 9.424521e+09*R_pow(x, 7.0) + 1.051881e+12*R_pow(x, 9.0) - 7.650046e+13*R_pow(x, 11.0) + 3.901523e+15*R_pow(x, 13.0) - 1.468459e+17*R_pow(x, 15.0) + 4.234777e+18*R_pow(x, 17.0) - 9.628545e+19*R_pow(x, 19.0) + 1.765233e+21*R_pow(x, 21.0) - 2.656920e+22*R_pow(x, 23.0) + 3.331778e+23*R_pow(x, 25.0) - 3.523521e+24*R_pow(x, 27.0) + 3.174641e+25*R_pow(x, 29.0) - 2.457786e+26*R_pow(x, 31.0) + 1.646903e+27*R_pow(x, 33.0) - 9.610164e+27*R_pow(x, 35.0) + 4.908975e+28*R_pow(x, 37.0) - 2.204733e+29*R_pow(x, 39.0) + 8.738270e+29*R_pow(x, 41.0) - 3.065652e+30*R_pow(x, 43.0) + 9.543778e+30*R_pow(x, 45.0) - 2.641534e+31*R_pow(x, 47.0) + 6.509495e+31*R_pow(x, 49.0) - 1.429536e+32*R_pow(x, 51.0) + 2.798903e+32*R_pow(x, 53.0) - 4.885358e+32*R_pow(x, 55.0) + 7.597405e+32*R_pow(x, 57.0) - 1.051470e+33*R_pow(x, 59.0) + 1.292791e+33*R_pow(x, 61.0) - 1.408633e+33*R_pow(x, 63.0) + 1.355809e+33*R_pow(x, 65.0) - 1.147931e+33*R_pow(x, 67.0) + 8.504277e+32*R_pow(x, 69.0) - 5.475591e+32*R_pow(x, 71.0) + 3.037828e+32*R_pow(x, 73.0) - 1.436263e+32*R_pow(x, 75.0) + 5.703820e+31*R_pow(x, 77.0) - 1.866099e+31*R_pow(x, 79.0) + 4.895630e+30*R_pow(x, 81.0) - 9.897717e+29*R_pow(x, 83.0) + 1.447229e+29*R_pow(x, 85.0) - 1.361734e+28*R_pow(x, 87.0) + 6.189700e+26*R_pow(x, 89.0);
    }
    break;
  case 90:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 4.140000e+03*R_pow(x, 2.0) - 2.853840e+06*R_pow(x, 4.0) + 7.853768e+08*R_pow(x, 6.0) - 1.154504e+11*R_pow(x, 8.0) + 1.051881e+13*R_pow(x, 10.0) - 6.502539e+14*R_pow(x, 12.0) + 2.898274e+16*R_pow(x, 14.0) - 9.728541e+17*R_pow(x, 16.0) + 2.540866e+19*R_pow(x, 18.0) - 5.295700e+20*R_pow(x, 20.0) + 8.986642e+21*R_pow(x, 22.0) - 1.262037e+23*R_pow(x, 24.0) + 1.486486e+24*R_pow(x, 26.0) - 1.484913e+25*R_pow(x, 28.0) + 1.269856e+26*R_pow(x, 30.0) - 9.370310e+26*R_pow(x, 32.0) + 6.006352e+27*R_pow(x, 34.0) - 3.363557e+28*R_pow(x, 36.0) + 1.653550e+29*R_pow(x, 38.0) - 7.165382e+29*R_pow(x, 40.0) + 2.746314e+30*R_pow(x, 42.0) - 9.336305e+30*R_pow(x, 44.0) + 2.821639e+31*R_pow(x, 46.0) - 7.594411e+31*R_pow(x, 48.0) + 1.822659e+32*R_pow(x, 50.0) - 3.903733e+32*R_pow(x, 52.0) + 7.463742e+32*R_pow(x, 54.0) - 1.273683e+33*R_pow(x, 56.0) + 1.938648e+33*R_pow(x, 58.0) - 2.628676e+33*R_pow(x, 60.0) + 3.169424e+33*R_pow(x, 62.0) - 3.389523e+33*R_pow(x, 64.0) + 3.204640e+33*R_pow(x, 66.0) - 2.667251e+33*R_pow(x, 68.0) + 1.943835e+33*R_pow(x, 70.0) - 1.232008e+33*R_pow(x, 72.0) + 6.732483e+32*R_pow(x, 74.0) - 3.137101e+32*R_pow(x, 76.0) + 1.228515e+32*R_pow(x, 78.0) - 3.965460e+31*R_pow(x, 80.0) + 1.026888e+31*R_pow(x, 82.0) - 2.050241e+30*R_pow(x, 84.0) + 2.961772e+29*R_pow(x, 86.0) - 2.754417e+28*R_pow(x, 88.0) + 1.237940e+27*R_pow(x, 90.0);
    }
    break;
  case 91:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -9.200000e+01*x + 1.297200e+05*R_pow(x, 3.0) - 5.479373e+07*R_pow(x, 5.0) + 1.099527e+10*R_pow(x, 7.0) - 1.282782e+12*R_pow(x, 9.0) + 9.753808e+13*R_pow(x, 11.0) - 5.202031e+15*R_pow(x, 13.0) + 2.048114e+17*R_pow(x, 15.0) - 6.180485e+18*R_pow(x, 17.0) + 1.471028e+20*R_pow(x, 19.0) - 2.824373e+21*R_pow(x, 21.0) + 4.454249e+22*R_pow(x, 23.0) - 5.855852e+23*R_pow(x, 25.0) + 6.496493e+24*R_pow(x, 27.0) - 6.144466e+25*R_pow(x, 29.0) + 4.997499e+26*R_pow(x, 31.0) - 3.520965e+27*R_pow(x, 33.0) + 2.162287e+28*R_pow(x, 35.0) - 1.163609e+29*R_pow(x, 37.0) + 5.511832e+29*R_pow(x, 39.0) - 2.306903e+30*R_pow(x, 41.0) + 8.558279e+30*R_pow(x, 43.0) - 2.821639e+31*R_pow(x, 45.0) + 8.284812e+31*R_pow(x, 47.0) - 2.169832e+32*R_pow(x, 49.0) + 5.074853e+32*R_pow(x, 51.0) - 1.060637e+33*R_pow(x, 53.0) + 1.981284e+33*R_pow(x, 55.0) - 3.307106e+33*R_pow(x, 57.0) + 4.928767e+33*R_pow(x, 59.0) - 6.550143e+33*R_pow(x, 61.0) + 7.747481e+33*R_pow(x, 63.0) - 8.134855e+33*R_pow(x, 65.0) + 7.557210e+33*R_pow(x, 67.0) - 6.184929e+33*R_pow(x, 69.0) + 4.435229e+33*R_pow(x, 71.0) - 2.767799e+33*R_pow(x, 73.0) + 1.490123e+33*R_pow(x, 75.0) - 6.844584e+32*R_pow(x, 77.0) + 2.643640e+32*R_pow(x, 79.0) - 8.420483e+31*R_pow(x, 81.0) + 2.152754e+31*R_pow(x, 83.0) - 4.245206e+30*R_pow(x, 85.0) + 6.059716e+29*R_pow(x, 87.0) - 5.570730e+28*R_pow(x, 89.0) + 2.475880e+27*R_pow(x, 91.0);
    }
    break;
  case 92:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 4.324000e+03*R_pow(x, 2.0) + 3.113280e+06*R_pow(x, 4.0) - 8.949642e+08*R_pow(x, 6.0) + 1.374409e+11*R_pow(x, 8.0) - 1.308438e+13*R_pow(x, 10.0) + 8.453301e+14*R_pow(x, 12.0) - 3.938681e+16*R_pow(x, 14.0) + 1.382477e+18*R_pow(x, 16.0) - 3.776963e+19*R_pow(x, 18.0) + 8.237755e+20*R_pow(x, 20.0) - 1.463539e+22*R_pow(x, 22.0) + 2.152887e+23*R_pow(x, 24.0) - 2.657656e+24*R_pow(x, 26.0) + 2.784211e+25*R_pow(x, 28.0) - 2.498749e+26*R_pow(x, 30.0) + 1.936531e+27*R_pow(x, 32.0) - 1.304828e+28*R_pow(x, 34.0) + 7.688131e+28*R_pow(x, 36.0) - 3.980768e+29*R_pow(x, 38.0) + 1.818905e+30*R_pow(x, 40.0) - 7.360120e+30*R_pow(x, 42.0) + 2.645286e+31*R_pow(x, 44.0) - 8.464916e+31*R_pow(x, 46.0) + 2.416403e+32*R_pow(x, 48.0) - 6.162322e+32*R_pow(x, 50.0) + 1.405344e+33*R_pow(x, 52.0) - 2.867648e+33*R_pow(x, 54.0) + 5.236251e+33*R_pow(x, 56.0) - 8.552860e+33*R_pow(x, 58.0) + 1.248621e+34*R_pow(x, 60.0) - 1.626971e+34*R_pow(x, 62.0) + 1.888448e+34*R_pow(x, 64.0) - 1.947435e+34*R_pow(x, 66.0) + 1.778167e+34*R_pow(x, 68.0) - 1.431369e+34*R_pow(x, 70.0) + 1.010247e+34*R_pow(x, 72.0) - 6.208846e+33*R_pow(x, 74.0) + 3.293956e+33*R_pow(x, 76.0) - 1.491768e+33*R_pow(x, 78.0) + 5.683826e+32*R_pow(x, 80.0) - 1.786785e+32*R_pow(x, 82.0) + 4.510531e+31*R_pow(x, 84.0) - 8.786589e+30*R_pow(x, 86.0) + 1.239487e+30*R_pow(x, 88.0) - 1.126525e+29*R_pow(x, 90.0) + 4.951760e+27*R_pow(x, 92.0);
    }
    break;
  case 93:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 9.400000e+01*x - 1.383680e+05*R_pow(x, 3.0) + 6.102029e+07*R_pow(x, 5.0) - 1.278520e+10*R_pow(x, 7.0) + 1.557664e+12*R_pow(x, 9.0) - 1.237068e+14*R_pow(x, 11.0) + 6.892691e+15*R_pow(x, 13.0) - 2.835850e+17*R_pow(x, 15.0) + 8.945439e+18*R_pow(x, 17.0) - 2.226420e+20*R_pow(x, 19.0) + 4.471924e+21*R_pow(x, 21.0) - 7.381326e+22*R_pow(x, 23.0) + 1.016163e+24*R_pow(x, 25.0) - 1.181180e+25*R_pow(x, 27.0) + 1.171289e+26*R_pow(x, 29.0) - 9.994998e+26*R_pow(x, 31.0) + 7.394027e+27*R_pow(x, 33.0) - 4.771943e+28*R_pow(x, 35.0) + 2.701235e+29*R_pow(x, 37.0) - 1.347337e+30*R_pow(x, 39.0) + 5.944713e+30*R_pow(x, 41.0) - 2.327852e+31*R_pow(x, 43.0) + 8.112212e+31*R_pow(x, 45.0) - 2.521464e+32*R_pow(x, 47.0) + 7.002639e+32*R_pow(x, 49.0) - 1.739950e+33*R_pow(x, 51.0) + 3.871325e+33*R_pow(x, 53.0) - 7.716580e+33*R_pow(x, 55.0) + 1.377961e+34*R_pow(x, 57.0) - 2.203449e+34*R_pow(x, 59.0) + 3.152256e+34*R_pow(x, 61.0) - 4.028690e+34*R_pow(x, 63.0) + 4.590382e+34*R_pow(x, 65.0) - 4.650591e+34*R_pow(x, 67.0) + 4.174827e+34*R_pow(x, 69.0) - 3.306261e+34*R_pow(x, 71.0) + 2.297273e+34*R_pow(x, 73.0) - 1.390781e+34*R_pow(x, 75.0) + 7.272371e+33*R_pow(x, 77.0) - 3.247901e+33*R_pow(x, 79.0) + 1.220970e+33*R_pow(x, 81.0) - 3.788846e+32*R_pow(x, 83.0) + 9.445583e+31*R_pow(x, 85.0) - 1.817915e+31*R_pow(x, 87.0) + 2.534682e+30*R_pow(x, 89.0) - 2.277810e+29*R_pow(x, 91.0) + 9.903520e+27*R_pow(x, 93.0);
    }
    break;
  case 94:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 4.512000e+03*R_pow(x, 2.0) - 3.390016e+06*R_pow(x, 4.0) + 1.017005e+09*R_pow(x, 6.0) - 1.630113e+11*R_pow(x, 8.0) + 1.619970e+13*R_pow(x, 10.0) - 1.092744e+15*R_pow(x, 12.0) + 5.317219e+16*R_pow(x, 14.0) - 1.949647e+18*R_pow(x, 16.0) + 5.566051e+19*R_pow(x, 18.0) - 1.269060e+21*R_pow(x, 20.0) + 2.357924e+22*R_pow(x, 22.0) - 3.629152e+23*R_pow(x, 24.0) + 4.689981e+24*R_pow(x, 26.0) - 5.146572e+25*R_pow(x, 28.0) + 4.841327e+26*R_pow(x, 30.0) - 3.935530e+27*R_pow(x, 32.0) + 2.783634e+28*R_pow(x, 34.0) - 1.723202e+29*R_pow(x, 36.0) + 9.383238e+29*R_pow(x, 38.0) - 4.513578e+30*R_pow(x, 40.0) + 1.924955e+31*R_pow(x, 42.0) - 7.300990e+31*R_pow(x, 44.0) + 2.468934e+32*R_pow(x, 46.0) - 7.459332e+32*R_pow(x, 48.0) + 2.016760e+33*R_pow(x, 50.0) - 4.885243e+33*R_pow(x, 52.0) + 1.061030e+34*R_pow(x, 54.0) - 2.066941e+34*R_pow(x, 56.0) + 3.611208e+34*R_pow(x, 58.0) - 5.655518e+34*R_pow(x, 60.0) + 7.931483e+34*R_pow(x, 62.0) - 9.945828e+34*R_pow(x, 64.0) + 1.112820e+35*R_pow(x, 66.0) - 1.107935e+35*R_pow(x, 68.0) + 9.781023e+34*R_pow(x, 70.0) - 7.622769e+34*R_pow(x, 72.0) + 5.215430e+34*R_pow(x, 74.0) - 3.110959e+34*R_pow(x, 76.0) + 1.603651e+34*R_pow(x, 78.0) - 7.064184e+33*R_pow(x, 80.0) + 2.620619e+33*R_pow(x, 82.0) - 8.028746e+32*R_pow(x, 84.0) + 1.976983e+32*R_pow(x, 86.0) - 3.759779e+31*R_pow(x, 88.0) + 5.182017e+30*R_pow(x, 90.0) - 4.605137e+29*R_pow(x, 92.0) + 1.980704e+28*R_pow(x, 94.0);
    }
    break;
  case 95:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -9.600000e+01*x + 1.473920e+05*R_pow(x, 3.0) - 6.780032e+07*R_pow(x, 5.0) + 1.481921e+10*R_pow(x, 7.0) - 1.883687e+12*R_pow(x, 9.0) + 1.561062e+14*R_pow(x, 11.0) - 9.078179e+15*R_pow(x, 13.0) + 3.899294e+17*R_pow(x, 15.0) - 1.284473e+19*R_pow(x, 17.0) + 3.339631e+20*R_pow(x, 19.0) - 7.010043e+21*R_pow(x, 21.0) + 1.209717e+23*R_pow(x, 23.0) - 1.741993e+24*R_pow(x, 25.0) + 2.119177e+25*R_pow(x, 27.0) - 2.200603e+26*R_pow(x, 29.0) + 1.967765e+27*R_pow(x, 31.0) - 1.526509e+28*R_pow(x, 33.0) + 1.033921e+29*R_pow(x, 35.0) - 6.147639e+29*R_pow(x, 37.0) + 3.223984e+30*R_pow(x, 39.0) - 1.497187e+31*R_pow(x, 41.0) + 6.177761e+31*R_pow(x, 43.0) - 2.271419e+32*R_pow(x, 45.0) + 7.459332e+32*R_pow(x, 47.0) - 2.192130e+33*R_pow(x, 49.0) + 5.773470e+33*R_pow(x, 51.0) - 1.364181e+34*R_pow(x, 53.0) + 2.893718e+34*R_pow(x, 55.0) - 5.511843e+34*R_pow(x, 57.0) + 9.425864e+34*R_pow(x, 59.0) - 1.446329e+35*R_pow(x, 61.0) + 1.989166e+35*R_pow(x, 63.0) - 2.448204e+35*R_pow(x, 65.0) + 2.690699e+35*R_pow(x, 67.0) - 2.633352e+35*R_pow(x, 69.0) + 2.286831e+35*R_pow(x, 71.0) - 1.754281e+35*R_pow(x, 73.0) + 1.182164e+35*R_pow(x, 75.0) - 6.949154e+34*R_pow(x, 77.0) + 3.532092e+34*R_pow(x, 79.0) - 1.534934e+34*R_pow(x, 81.0) + 5.620122e+33*R_pow(x, 83.0) - 1.700205e+33*R_pow(x, 85.0) + 4.135757e+32*R_pow(x, 87.0) - 7.773026e+31*R_pow(x, 89.0) + 1.059181e+31*R_pow(x, 91.0) - 9.309309e+29*R_pow(x, 93.0) + 3.961408e+28*R_pow(x, 95.0);
    }
    break;
  case 96:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 4.704000e+03*R_pow(x, 2.0) + 3.684800e+06*R_pow(x, 4.0) - 1.152605e+09*R_pow(x, 6.0) + 1.926498e+11*R_pow(x, 8.0) - 1.996708e+13*R_pow(x, 10.0) + 1.404956e+15*R_pow(x, 12.0) - 7.132855e+16*R_pow(x, 14.0) + 2.729506e+18*R_pow(x, 16.0) - 8.134997e+19*R_pow(x, 18.0) + 1.936986e+21*R_pow(x, 20.0) - 3.759932e+22*R_pow(x, 22.0) + 6.048587e+23*R_pow(x, 24.0) - 8.173967e+24*R_pow(x, 26.0) + 9.384925e+25*R_pow(x, 28.0) - 9.242533e+26*R_pow(x, 30.0) + 7.871061e+27*R_pow(x, 32.0) - 5.836651e+28*R_pow(x, 34.0) + 3.791044e+29*R_pow(x, 36.0) - 2.167852e+30*R_pow(x, 38.0) + 1.096155e+31*R_pow(x, 40.0) - 4.919328e+31*R_pow(x, 42.0) + 1.965651e+32*R_pow(x, 44.0) - 7.011772e+32*R_pow(x, 46.0) + 2.237800e+33*R_pow(x, 48.0) - 6.401021e+33*R_pow(x, 50.0) + 1.643218e+34*R_pow(x, 52.0) - 3.789392e+34*R_pow(x, 54.0) + 7.854377e+34*R_pow(x, 56.0) - 1.463489e+35*R_pow(x, 58.0) + 2.450725e+35*R_pow(x, 60.0) - 3.685807e+35*R_pow(x, 62.0) + 4.972914e+35*R_pow(x, 64.0) - 6.009228e+35*R_pow(x, 66.0) + 6.489333e+35*R_pow(x, 68.0) - 6.244807e+35*R_pow(x, 70.0) + 5.335938e+35*R_pow(x, 72.0) - 4.030105e+35*R_pow(x, 74.0) + 2.675424e+35*R_pow(x, 76.0) - 1.550196e+35*R_pow(x, 78.0) + 7.770602e+34*R_pow(x, 80.0) - 3.331929e+34*R_pow(x, 82.0) + 1.204312e+34*R_pow(x, 84.0) - 3.598108e+33*R_pow(x, 86.0) + 8.647491e+32*R_pow(x, 88.0) - 1.606425e+32*R_pow(x, 90.0) + 2.164414e+31*R_pow(x, 92.0) - 1.881669e+30*R_pow(x, 94.0) + 7.922816e+28*R_pow(x, 96.0);
    }
    break;
  case 97:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 9.800000e+01*x - 1.568000e+05*R_pow(x, 3.0) + 7.516992e+07*R_pow(x, 5.0) - 1.712442e+10*R_pow(x, 7.0) + 2.268986e+12*R_pow(x, 9.0) - 1.960404e+14*R_pow(x, 11.0) + 1.188809e+16*R_pow(x, 13.0) - 5.325865e+17*R_pow(x, 15.0) + 1.830374e+19*R_pow(x, 17.0) - 4.966630e+20*R_pow(x, 19.0) + 1.088401e+22*R_pow(x, 21.0) - 1.961704e+23*R_pow(x, 23.0) + 2.951710e+24*R_pow(x, 25.0) - 3.753970e+25*R_pow(x, 27.0) + 4.077588e+26*R_pow(x, 29.0) - 3.816272e+27*R_pow(x, 31.0) + 3.100721e+28*R_pow(x, 33.0) - 2.201251e+29*R_pow(x, 35.0) + 1.372973e+30*R_pow(x, 37.0) - 7.559687e+30*R_pow(x, 39.0) + 3.689496e+31*R_pow(x, 41.0) - 1.601642e+32*R_pow(x, 43.0) + 6.202722e+32*R_pow(x, 45.0) - 2.148288e+33*R_pow(x, 47.0) + 6.667730e+33*R_pow(x, 49.0) - 1.857551e+34*R_pow(x, 51.0) + 4.650618e+34*R_pow(x, 53.0) - 1.047250e+35*R_pow(x, 55.0) + 2.122060e+35*R_pow(x, 57.0) - 3.869565e+35*R_pow(x, 59.0) + 6.347779e+35*R_pow(x, 61.0) - 9.360779e+35*R_pow(x, 63.0) + 1.239403e+36*R_pow(x, 65.0) - 1.470915e+36*R_pow(x, 67.0) + 1.561202e+36*R_pow(x, 69.0) - 1.477645e+36*R_pow(x, 71.0) + 1.242616e+36*R_pow(x, 73.0) - 9.242375e+35*R_pow(x, 75.0) + 6.045764e+35*R_pow(x, 77.0) - 3.453601e+35*R_pow(x, 79.0) + 1.707614e+35*R_pow(x, 81.0) - 7.225871e+34*R_pow(x, 83.0) + 2.578644e+34*R_pow(x, 85.0) - 7.609792e+33*R_pow(x, 87.0) + 1.807228e+33*R_pow(x, 89.0) - 3.318769e+32*R_pow(x, 91.0) + 4.421922e+31*R_pow(x, 93.0) - 3.802952e+30*R_pow(x, 95.0) + 1.584563e+29*R_pow(x, 97.0);
    }
    break;
  case 98:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 4.900000e+03*R_pow(x, 2.0) - 3.998400e+06*R_pow(x, 4.0) + 1.302945e+09*R_pow(x, 6.0) - 2.268986e+11*R_pow(x, 8.0) + 2.450505e+13*R_pow(x, 10.0) - 1.797037e+15*R_pow(x, 12.0) + 9.510473e+16*R_pow(x, 14.0) - 3.794679e+18*R_pow(x, 16.0) + 1.179575e+20*R_pow(x, 18.0) - 2.930312e+21*R_pow(x, 20.0) + 5.936735e+22*R_pow(x, 22.0) - 9.971995e+23*R_pow(x, 24.0) + 1.407739e+25*R_pow(x, 26.0) - 1.689287e+26*R_pow(x, 28.0) + 1.739771e+27*R_pow(x, 30.0) - 1.550360e+28*R_pow(x, 32.0) + 1.203809e+29*R_pow(x, 34.0) - 8.193546e+29*R_pow(x, 36.0) + 4.913797e+30*R_pow(x, 38.0) - 2.608092e+31*R_pow(x, 40.0) + 1.229832e+32*R_pow(x, 42.0) - 5.168935e+32*R_pow(x, 44.0) + 1.941722e+33*R_pow(x, 46.0) - 6.534375e+33*R_pow(x, 48.0) + 1.973648e+34*R_pow(x, 50.0) - 5.358320e+34*R_pow(x, 52.0) + 1.309063e+35*R_pow(x, 54.0) - 2.879938e+35*R_pow(x, 56.0) + 5.707609e+35*R_pow(x, 58.0) - 1.018986e+36*R_pow(x, 60.0) + 1.638136e+36*R_pow(x, 62.0) - 2.369447e+36*R_pow(x, 64.0) + 3.079729e+36*R_pow(x, 66.0) - 3.590764e+36*R_pow(x, 68.0) + 3.746884e+36*R_pow(x, 70.0) - 3.488883e+36*R_pow(x, 72.0) + 2.888242e+36*R_pow(x, 74.0) - 2.116017e+36*R_pow(x, 76.0) + 1.364172e+36*R_pow(x, 78.0) - 7.684262e+35*R_pow(x, 80.0) + 3.748421e+35*R_pow(x, 82.0) - 1.565605e+35*R_pow(x, 84.0) + 5.517099e+34*R_pow(x, 86.0) - 1.608433e+34*R_pow(x, 88.0) + 3.775099e+33*R_pow(x, 90.0) - 6.853979e+32*R_pow(x, 92.0) + 9.032011e+31*R_pow(x, 94.0) - 7.685132e+30*R_pow(x, 96.0) + 3.169127e+29*R_pow(x, 98.0);
    }
    break;
  case 99:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+02*x + 1.666000e+05*R_pow(x, 3.0) - 8.316672e+07*R_pow(x, 5.0) + 1.973031e+10*R_pow(x, 7.0) - 2.722783e+12*R_pow(x, 9.0) + 2.450505e+14*R_pow(x, 11.0) - 1.548217e+16*R_pow(x, 13.0) + 7.227959e+17*R_pow(x, 15.0) - 2.589310e+19*R_pow(x, 17.0) + 7.325779e+20*R_pow(x, 19.0) - 1.674464e+22*R_pow(x, 21.0) + 3.149051e+23*R_pow(x, 23.0) - 4.946109e+24*R_pow(x, 25.0) + 6.569448e+25*R_pow(x, 27.0) - 7.456161e+26*R_pow(x, 29.0) + 7.295814e+27*R_pow(x, 31.0) - 6.201442e+28*R_pow(x, 33.0) + 4.608870e+29*R_pow(x, 35.0) - 3.011682e+30*R_pow(x, 37.0) + 1.738728e+31*R_pow(x, 39.0) - 8.905681e+31*R_pow(x, 41.0) + 4.061306e+32*R_pow(x, 43.0) - 1.654059e+33*R_pow(x, 45.0) + 6.031731e+33*R_pow(x, 47.0) - 1.973648e+34*R_pow(x, 49.0) + 5.804847e+34*R_pow(x, 51.0) - 1.536726e+35*R_pow(x, 53.0) + 3.665376e+35*R_pow(x, 55.0) - 7.881936e+35*R_pow(x, 57.0) + 1.528478e+36*R_pow(x, 59.0) - 2.672749e+36*R_pow(x, 61.0) + 4.212351e+36*R_pow(x, 63.0) - 5.978298e+36*R_pow(x, 65.0) + 7.630374e+36*R_pow(x, 67.0) - 8.742730e+36*R_pow(x, 69.0) + 8.971413e+36*R_pow(x, 71.0) - 8.220382e+36*R_pow(x, 73.0) + 6.700722e+36*R_pow(x, 75.0) - 4.836611e+36*R_pow(x, 77.0) + 3.073705e+36*R_pow(x, 79.0) - 1.707614e+36*R_pow(x, 81.0) + 8.219428e+35*R_pow(x, 83.0) - 3.389075e+35*R_pow(x, 85.0) + 1.179518e+35*R_pow(x, 87.0) - 3.397589e+34*R_pow(x, 89.0) + 7.882076e+33*R_pow(x, 91.0) - 1.415015e+33*R_pow(x, 93.0) + 1.844432e+32*R_pow(x, 95.0) - 1.552872e+31*R_pow(x, 97.0) + 6.338253e+29*R_pow(x, 99.0);
    }
    break;
  case 100:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 5.100000e+03*R_pow(x, 2.0) + 4.331600e+06*R_pow(x, 4.0) - 1.469279e+09*R_pow(x, 6.0) + 2.663592e+11*R_pow(x, 8.0) - 2.995062e+13*R_pow(x, 10.0) + 2.287138e+15*R_pow(x, 12.0) - 1.260691e+17*R_pow(x, 14.0) + 5.240271e+18*R_pow(x, 16.0) - 1.697437e+20*R_pow(x, 18.0) + 4.395468e+21*R_pow(x, 20.0) - 9.285663e+22*R_pow(x, 22.0) + 1.627010e+24*R_pow(x, 24.0) - 2.396961e+25*R_pow(x, 26.0) + 3.003176e+26*R_pow(x, 28.0) - 3.231003e+27*R_pow(x, 30.0) + 3.009523e+28*R_pow(x, 32.0) - 2.444098e+29*R_pow(x, 34.0) + 1.741129e+30*R_pow(x, 36.0) - 1.093716e+31*R_pow(x, 38.0) + 6.085548e+31*R_pow(x, 40.0) - 3.010968e+32*R_pow(x, 42.0) + 1.329155e+33*R_pow(x, 44.0) - 5.249840e+33*R_pow(x, 46.0) + 1.859784e+34*R_pow(x, 48.0) - 5.920944e+34*R_pow(x, 50.0) + 1.696801e+35*R_pow(x, 52.0) - 4.382514e+35*R_pow(x, 54.0) + 1.021069e+36*R_pow(x, 56.0) - 2.147148e+36*R_pow(x, 58.0) + 4.075942e+36*R_pow(x, 60.0) - 6.983634e+36*R_pow(x, 62.0) + 1.079415e+37*R_pow(x, 64.0) - 1.503632e+37*R_pow(x, 66.0) + 1.885151e+37*R_pow(x, 68.0) - 2.123234e+37*R_pow(x, 70.0) + 2.143171e+37*R_pow(x, 72.0) - 1.932901e+37*R_pow(x, 74.0) + 1.551746e+37*R_pow(x, 76.0) - 1.103739e+37*R_pow(x, 78.0) + 6.915836e+36*R_pow(x, 80.0) - 3.790070e+36*R_pow(x, 82.0) + 1.800446e+36*R_pow(x, 84.0) - 7.329860e+35*R_pow(x, 86.0) + 2.519879e+35*R_pow(x, 88.0) - 7.172689e+34*R_pow(x, 90.0) + 1.644955e+34*R_pow(x, 92.0) - 2.920350e+33*R_pow(x, 94.0) + 3.765715e+32*R_pow(x, 96.0) - 3.137435e+31*R_pow(x, 98.0) + 1.267651e+30*R_pow(x, 100.0);
    }
    break;
 
 default:
 warning("n =  101  but it cannot be greater than  100 , contact the author to increase that value");
}
 return;
}
}
