% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotScorem.R
\name{plotScorem}
\alias{plotScorem}
\title{Plot score matrix for prcomp result based on group}
\usage{
plotScorem(prcompResult, ncomp = 4, group, cex = 1.5, col = NULL,
  pch = NULL, legendtitle = NULL, ...)
}
\arguments{
\item{prcompResult}{output object from \code{\link[stats]{prcomp}} function}

\item{ncomp}{maximum number of PC score to plot}

\item{group}{variable of numeric, character or factor class separating
the samples into groups.}

\item{cex}{(optional) size of points on graphs}

\item{col}{point color}

\item{pch}{point type}

\item{legendtitle}{legend title}

\item{...}{additional arguments to be passed on to \code{\link[graphics]{pairs}}}
}
\value{
A figure is returned on the graphic device
}
\description{
Plot score matrix for \code{\link[stats]{prcomp}} (PCA) result based on group
}
\examples{
data(applejuice)
# country of apple production
country <- sapply(strsplit(names(applejuice), split = "-"), "[", 1)

applejuice_uf <- unfold(applejuice) # unfold list into matrix
result <- prcomp(applejuice_uf)
# plot PC1 vs PC3 score based on country of production
plotScorem(result, ncomp = 4, group = country)

# specify colours
plotScorem(result, ncomp = 4, group = country, col = c("black", "grey"))
}
\seealso{
\code{\link{pairs}}, \code{\link{plotScore}}
}

