% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMT.R
\name{SMT}
\alias{SMT}
\title{Sequential Chi Square Model Tests, RMSEA lower bound, and AIC}
\source{
Auerswald, M., & Moshagen, M. (2019). How to determine the number of
factors to retain in exploratory factor analysis: A comparison of extraction
methods under realistic conditions. Psychological Methods, 24(4), 468–491.
https://doi.org/10.1037/met0000200

Browne, M.W., & Cudeck, R. (1992). Alternative ways of assessing model
fit. Sociological Methods and Research, 21, 230–258.

Preacher, K. J., Zhang G., Kim, C., & Mels, G. (2013). Choosing the
Optimal Number of Factors in Exploratory Factor Analysis: A Model Selection
Perspective, Multivariate Behavioral Research, 48(1), 28-56,
doi:10.108/00273171.2012.710386

Steiger, J. H., & Lind, J. C. (1980, May). Statistically based tests
for the number of common factors. Paper presented at the annual meeting of
the Psychometric Society, Iowa City, IA.
}
\usage{
SMT(
  x,
  N = NA,
  use = c("pairwise.complete.obs", "all.obs", "complete.obs", "everything",
    "na.or.complete"),
  cor_method = c("pearson", "spearman", "kendall")
)
}
\arguments{
\item{x}{data.frame or matrix. Dataframe or matrix of raw data or matrix with
correlations.}

\item{N}{numeric. The number of observations. Needs only be specified if a
correlation matrix is used.}

\item{use}{character. Passed to \code{\link[stats:cor]{stats::cor}} if raw
data is given as input. Default is "pairwise.complete.obs".}

\item{cor_method}{character. Passed to \code{\link[stats:cor]{stats::cor}}.
Default is "pearson".}
}
\value{
A list of class SMT containing
\item{nfac_chi}{The number of factors to retain according to the significance
of the chi square value.}
\item{nfac_RMSEA}{The number of factors to retain according to the RMSEA lower
bound}
\item{nfac_AIC}{The number of factors to retain according to the AIC}
\item{p_null}{The p-value for the null model (zero factors)}
\item{ps_chi}{The p-values for EFA models with increasing numbers of factors,
starting with 1 factor}
\item{RMSEA_LB_null}{The lower bounds of the 90\% confidence interval for the RMSEA
for the null model (zero factors).}
\item{RMSEA_LBs}{The lower bounds of the 90\% confidence interval for the RMSEA
for EFA models with increasing numbers of factors, starting with 1 factor}
\item{AIC_null}{The AICs for the null model (zero factors)}
\item{AICs}{The AICs for EFA models with increasing numbers of factors,
starting with 1 factor}
}
\description{
Sequential Chi Square Model Tests (SMT) are a factor retention method where
multiple
EFAs with increasing numbers of factors are fitted and the number of factors
for which the Chi Square value first becomes non-significant is taken as the
suggested number of factors.
Preacher, Zhang, Kim, & Mels (2013) suggested a similar approach with the
lower bound of the 90\% confidence interval of the Root Mean Square Error of
Approximation (RMSEA; Browne & Cudeck, 1992; Steiger & Lind, 1980), and with
the Akaike Information Criterion (AIC). For the RMSEA, the
number of factors for which this lower bound first falls below .05 is the
suggested number of factors to retain. For the AIC, it is the number of factors
where the AIC is lowest.
}
\details{
As a first step in the procedure, a maximum number of factors to extract is
determined for which the model is still over-identified (df > 0).

Then, EFAs with increasing numbers of factors from 1 to the maximum number are
fitted with maximum likelihood estimation.

For the SMT, first the significance of the chi
square value for a model with 0 factors is determined. If this value is
not significant, 0 factors are suggested to retain. If it is significant,
a model with 1 factor is estimated and the significance of its chi square value
is determined, and so on, until a non-significant result is obtained. The
suggested number of factors is the number of factors for the model where the
chi square value first becomes non-significant.

Regarding the RMSEA, the suggested number of factors is the number of factors
for the model where the lower bound of the 90\% confidence interval of the
RMSEA first falls below the .05 threshold.

Regarding the AIC, the suggested number of factors is the number of factors
for the model with the lowest AIC.

In comparison with other prominent factor retention criteria, SMT performed
well at determining the number of factors to extract in EFA (Auerswald &
Moshagen, 2019). The RMSEA lower bound also performed well at determining the true
number of factors, while the AIC performed well at determining the
most generalizable model (Preacher, Zhang, Kim, & Mels, 2013).

The \code{SMT} function can also be called together with other factor
retention criteria in the \code{\link{N_FACTORS}} function.
}
\examples{
SMT_base <- SMT(test_models$baseline$cormat, N = 500)
SMT_base

}
\seealso{
Other factor retention criteria: \code{\link{CD}}, \code{\link{EKC}},
\code{\link{HULL}}, \code{\link{KGC}}, \code{\link{PARALLEL}}

\code{\link{N_FACTORS}} as a wrapper function for this and all the
above-mentioned factor retention criteria.
}
