% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.scores.R
\name{net.scores}
\alias{net.scores}
\title{Network Scores}
\usage{
net.scores(data, A, wc, global = TRUE, type = c("sumscore", "latent"),
  ...)
}
\arguments{
\item{data}{Matrix or data frame.
Must be a dataset}

\item{A}{Matrix, data frame, or \code{\link[EGAnet]{EGA}} object. 
An adjacency matrix of network data}

\item{wc}{Numeric. 
A vector of community assignments.
Not necessary if an \code{\link[EGAnet]{EGA}} object
is input for argument \code{A}}

\item{global}{Boolean.
Should general network loadings be computed in scores?
Defaults to \code{TRUE}.
If there is more than one dimension and there is theoretically
one global dimension, then general loadings of the dimensions
onto the global dimension can be included in the weighted
scores. For the type of weights (e.g., sum score or latent),
see the \code{type} argument}

\item{type}{Character.
Should network scores parallel sum scores or latent variable scores?
Defaults to \code{"latent"}.
Argument \code{type} sets the community centrality measure that is used
when computing the network loadings for multiple factors.
Simulations have shown that \code{\link[NetworkToolbox]{comm.eigen}} computes
weights that are closer to sum scores while
\code{\link[NetworkToolbox]{comm.close}} computes
weights that are closer to latent variable scores.
See Christensen, Golino, and Silvia (2019) for more details}

\item{...}{Additional arguments for \code{\link[igraph]{cluster_walktrap}}
and \code{\link[NetworkToolbox]{louvain}} community detection algorithms}
}
\value{
Returns a list containing:

\item{unstd.scores}{The unstandardized network scores for each participant
and community (including the overall score)}

\item{std.scores}{The standardized network scores for each participant
and community (including the overall score)}

\item{commCor}{Partial correlations between the specified or identified communities}

\item{loads}{Standardized network loadings for each item in each dimension
(computed using \code{\link[EGAnet]{net.loads}})}
}
\description{
This function computes network scores for
factor analysis models. Network scores are computed based on 
each node's \code{\link[NetworkToolbox]{strength}} within each
community (i.e., factor) in the network. These values are used
as network "factor loadings" for the weights of each item. Notably,
network analysis allows nodes to load onto more than one factor.
These loadings are considered in the factor scores. In addition,
if the construct is a hierarchy (e.g., personality questionnaire;
items in facet scales in a trait domain), then an overall
score can be computed (see argument \code{general}). These overall
scores are computed using \code{\link[NetworkToolbox]{comm.close}}
as weights, which are roughly similar to general factor loadings in a
CFA model (see Christensen, Golino, & Silvia, 2019). The score
estimates are roughly equivalent to the Maximum Likelihood method in
\code{lavaan}'s \code{\link[lavaan]{cfa}} function. An important difference
is that the network scores account for cross-loadings in their
estimation of scores.
}
\details{
For more details, type \code{vignette("Network_Scores")}
}
\examples{
# Load data
wmt <- wmt2[,7:24]

\dontrun{
 # Estimate EGA
 ega.wmt <- EGA(wmt)
}
 
 # Network scores
 net.scores(data = wmt, A = ega.wmt)

}
\references{
Christensen, A. P. (2018).
NetworkToolbox: Methods and measures for brain, cognitive, and psychometric network analysis in R.
\emph{The R Journal}, \emph{10}, 422-439.
doi: \href{https://doi.org/10.32614/RJ-2018-065}{10.32614/RJ-2018-065}

Christensen, A. P., Golino, H. F., & Silvia, P. J. (2019).
A psychometric network perspective on the measurement and assessment of personality traits.
\emph{PsyArXiv}.
doi: \href{https://doi.org/10.31234/osf.io/ktejp}{10.31234/osf.io/ktejp}
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com> and Hudson F. Golino <hfg9s at virginia.edu>
}
