% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LCT.R
\name{LCT}
\alias{LCT}
\title{Loadings Comparison Test}
\usage{
LCT(data, n, iter = 100)
}
\arguments{
\item{data}{Matrix or data frame.
A dataframe with the variables to be used in the test or a correlation matrix.
If the data used is a correlation matrix, the argument \code{n} will need to be specified}

\item{n}{Integer.
Sample size (if the data provided is a correlation matrix)}

\item{iter}{Integer.
Number of replicate samples to be drawn from a multivariate
normal distribution (uses \code{mvtnorm::mvrnorm}).
Defaults to \code{100}}
}
\value{
Returns a list containing:

\item{empirical}{Prediction of model based on empirical dataset only}

\item{bootstrap}{Prediction of model based on means of the loadings across
the bootstrap replicate samples}

\item{proportion}{Proportions of models suggested across bootstraps}
}
\description{
An algorithm to identify whether data were generated from a
random, factor, or network model using factor and network loadings.
The algorithm uses heuristics based on theory and simulation. These
heuristics were then submitted to several deep learning neural networks
with 240,000 samples per model with varying parameters.
}
\examples{
\donttest{# Compute LCT
## Network model
LCT(data = wmt2[,7:24])

## Factor model
LCT(data = NetworkToolbox::neoOpen)}

}
\references{
# Original implementation of LCT \cr
Christensen, A. P., & Golino, H. (in press).
On the equivalency of factor and network loadings.
\emph{Behavior Research Methods}.
\doi{10.31234/osf.io/xakez}

# Current implementation of LCT \cr
Christensen, A. P., & Golino, H. (under review).
Random, factor, or network model? Predictions from neural networks.
\emph{PsyArXiv}.
\doi{10.31234/osf.io/awkcb}
}
\author{
Hudson F. Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen at gmail.com>
}
