% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.descriptives.R
\name{network.descriptives}
\alias{network.descriptives}
\title{Descriptive Statistics for Networks}
\usage{
network.descriptives(network)
}
\arguments{
\item{network}{Matrix, data frame,
\code{\link[qgraph]{qgraph}}, or \code{\link[EGAnet]{EGA}} object}
}
\value{
Numeric vector including:

\item{Mean_weight}{The average of the edge weights in the network}

\item{SD_weight}{The standard deviation of the edge weights in the network}

\item{Min_weight}{The minimum of the edge weights in the network}

\item{Max_weight}{The minimum of the edge weights in the network}

\item{Density}{The density of the network}

\item{ASPL}{The average shortest path length (ASPL) of the network (computed as unweighted)}

\item{CC}{The clustering coefficent (CC) of the network (computed as unweighted)}

\item{swn.rand}{Small-worldness measure based on random networks:

\deqn{swn.rand = (ASPL / ASPL_random) / (CC / CC_random)}

\code{swn.rand} > 1 suggests the network is small-world}

\item{swn.HG}{Small-worldness measure based on Humphries & Gurney (2008):

\deqn{swn.HG = (transitivity / transitivity_random) / (ASPL / ASPL_random)}

\code{swn.HG} > 1 suggests the network is small-world}

\item{swn.TJHBL}{Small-worldness measure based on Telesford, Joyce, Hayasaka, Burdette, & Laurienti (2011):

\deqn{swn.TJHBL = (ASPL_random / ASPL) - (CC / CC_lattice)}

\code{swn.TJHBL} near 0 suggests the network is small-world,
positive values suggest more random network characteristics,
negative values suggest more lattice network characteristics}

\item{scale-free_R-sq}{The R-squared fit of whether the degree distribution
follows the power-law (many small degrees, few large degrees)}
}
\description{
Computes descriptive statistics for network models
}
\examples{
# Load data
wmt <- wmt2[,7:24]

\donttest{# EGA example
ega.wmt <- EGA(
  data = wmt,
  plot.EGA = FALSE # No plot for CRAN
)}

# Compute descriptives
network.descriptives(ega.wmt)

}
\references{
# swn.HG \cr
Humphries, M. D., & Gurney, K. (2008).
Network 'small-world-ness': A quantitative method for determining canonical network equivalence.
\emph{PLoS one}, \emph{3}, e0002051

# swn.TJHBL \cr
Telesford, Q. K., Joyce, K. E., Hayasaka, S., Burdette, J. H., & Laurienti, P. J. (2011).
The ubiquity of small-world networks.
\emph{Brain Connectivity}, \emph{1}(5), 367-375

# scale-free_R-sq \cr
Langfelder, P., & Horvath, S. (2008).
WGCNA: an R package for weighted correlation network analysis.
\emph{BMC Bioinformatics}, \emph{9}, 559
}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
