% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.compare.R
\name{community.compare}
\alias{community.compare}
\title{Compares Community Detection Solutions Using Permutation}
\usage{
community.compare(
  base,
  comparison,
  method = c("vi", "nmi", "split.join", "rand", "adjusted.rand"),
  iter = 1000,
  verbose = TRUE,
  seed = NULL
)
}
\arguments{
\item{base}{Character or numeric vector.
A vector of characters or numbers that are treated as the 
baseline communities}

\item{comparison}{Character or numeric vector (length = \code{length(base)}).
A vector of characters or numbers that are treated as the 
baseline communities}

\item{method}{Character (length = 1).
Comparison metrics from \code{\link[igraph]{compare}}.
Defaults to \code{"adjusted.rand"}.
Available options:

\itemize{

\item \code{"vi"} --- Variation of information (Meila, 2003)

\item \code{"nmi"} --- Normalized mutual information (Danon et al., 2003)

\item \code{"split.join"} --- Split-join distance (Dongen, 2000)

\item \code{"rand"} --- Rand index (Rand, 1971)

\item \code{"adjusted.rand"} --- adjusted Rand index (Hubert & Arabie, 1985; Steinley, 2004)

}}

\item{iter}{Numeric (length = 1).
Number of permutations to perform.
Defaults to \code{1000} (recommended)}

\item{verbose}{Boolean (length = 1).
Should progress be displayed?
Defaults to \code{TRUE}.
Set to \code{FALSE} to not display progress}

\item{seed}{Numeric (length = 1).
Defaults to \code{NULL} or random results.
Set for reproducible results.
See \href{https://r-ega.net/articles/reproducibility-prng.html}{Reproducibility and PRNG}
for more details on random number generation in \code{\link{EGAnet}}}
}
\value{
Returns data frame containing method used (\code{Method}), empirical or observed
value (\code{Empirical}), and p-value based on the permutation test (\code{p.value})
}
\description{
A permutation implementation to determine statistical
significance of whether the community comparison measure is different
from zero
}
\examples{
# Load data
wmt <- wmt2[,7:24]

# Estimate network
network <- EBICglasso.qgraph(data = wmt)

# Compute Edge Betweenness
edge_between <- community.detection(network, algorithm = "edge_betweenness")

# Compute Fast Greedy
fast_greedy <- community.detection(network, algorithm = "fast_greedy")

# Perform permutation test
community.compare(edge_between, fast_greedy)

}
\references{
\strong{Implementation of Permutation Test} \cr
Qannari, E. M., Courcoux, P., & Faye, P. (2014). 
Significance test of the adjusted Rand index. Application to the free sorting task. 
\emph{Food Quality and Preference}, \emph{32}, 93–97.

\strong{Variation of Information} \cr
Meila, M. (2003, August).
Comparing clusterings by the variation of information. 
In \emph{Learning Theory and Kernel Machines: 16th Annual Conference on Learning Theory and 7th Kernel Workshop}, 
COLT/Kernel 2003, Washington, DC, USA, August 24-27, 2003. Proceedings (pp. 173-187). Berlin, DE: Springer Berlin Heidelberg.

\strong{Normalized Mutual Information} \cr
Danon, L., Diaz-Guilera, A., Duch, J., & Arenas, A. (2005). 
Comparing community structure identification. 
\emph{Journal of Statistical Mechanics: Theory and Experiment}, \emph{2005}(09), P09008.

\strong{Split-join Distance} \cr
Dongen, S. (2000). 
Performance criteria for graph clustering and Markov cluster experiments. 
\emph{CWI (Centre for Mathematics and Computer Science)}.

\strong{Rand Index} \cr
Rand, W. M. (1971). 
Objective criteria for the evaluation of clustering methods. 
\emph{Journal of the American Statistical Association}, \emph{66}(336), 846-850.

\strong{Adjusted Rand Index} \cr
Hubert, L., & Arabie, P. (1985). 
Comparing partitions. 
\emph{Journal of Classification}, \emph{2}, 193-218.

Steinley, D. (2004). 
Properties of the Hubert-Arabie adjusted rand index. 
\emph{Psychological Methods}, \emph{9}(3), 386.
}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
