% Generated by roxygen2 (4.0.2): do not edit by hand
\name{as.egret}
\alias{as.egret}
\title{Create named list for EGRET analysis}
\usage{
as.egret(INFO, Daily, Sample = NA, surfaces = NA)
}
\arguments{
\item{INFO}{dataframe containing the INFO dataframe}

\item{Daily}{dataframe containing the daily data}

\item{Sample}{dataframe containing the sample data}

\item{surfaces}{matrix returned from \code{modelEstimation}. Default is NA.}
}
\value{
eList named list with Daily, Sample, and INFO dataframes, along with the surfaces matrix.
Any of these values can be NA, not all EGRET functions will work with missing parts of the named list eList.
}
\description{
Create a named list with the INFO, Daily, and Sample dataframes, and surface matrix. If any of these are
not available, an NA should be
}
\examples{
eList <- Choptank_eList
Daily <- getDaily(eList)
INFO <- getInfo(eList)
eList_flowHistory <- as.egret(INFO, Daily)
plotFlowSingle(eList_flowHistory, 1)
Sample <- getSample(eList)
surfaces <- getSurfaces(eList)
eList_full <- as.egret(INFO, Daily, Sample, surfaces)
plotFluxQ(eList_full)
}
\seealso{
\code{\link{readNWISDaily}}, \code{\link{readNWISSample}}
}
\keyword{USGS}
\keyword{WRTDS}
\keyword{data}
\keyword{import}

