% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/readMetaData.r
\name{readWQPInfo}
\alias{readWQPInfo}
\title{Import Metadata for Water Quality Portal Data}
\usage{
readWQPInfo(siteNumber, parameterCd, interactive = TRUE)
}
\arguments{
\item{siteNumber}{character site number.}

\item{parameterCd}{character USGS parameter code or characteristic name.}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}
}
\value{
INFO dataframe with agency, site, dateTime, value, and code columns
}
\description{
Populates INFO data frame for EGRET study. If siteNumber or parameter code (for USGS) or characteristic name
(for non-USGS) is provided, the function will make a call to the Water Quality Portal to get metadata information.
staAbbrev - station abbreviation, will be used in naming output files and for structuring batch jobs
constitAbbrev - constitute abbreviation
}
\examples{
# These examples require an internet connection to run
# Automatically gets information about site 01594440 and temperature, no interaction with user
nameToUse <- 'Specific conductance'
pcodeToUse <- '00095'
\dontrun{
INFO <- readWQPInfo('USGS-04024315',pcodeToUse)

INFO2 <- readWQPInfo('WIDNR_WQX-10032762',nameToUse)
# To adjust the label names:
INFO$shortName <- "Little"
INFO$paramShortName <- "SC"
}
}
\keyword{USGS}
\keyword{WRTDS}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}

