% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censoredSegments.R
\name{censoredSegments}
\alias{censoredSegments}
\title{Generic plotting function to create censored line segments}
\usage{
censoredSegments(yBottom, yLow, yHigh, x, Uncen, col = "black", lwd = 1)
}
\arguments{
\item{yBottom}{number specifying minimum flux (required)}

\item{yLow}{vector specifying the x data (required), such as ConcLow}

\item{yHigh}{vector specifying the x data (required), such as ConcHigh}

\item{x}{vector x data (required)}

\item{Uncen}{vector that defines whether the values are censored (0) or not (1)}

\item{col}{color of points on plot, see ?par 'Color Specification'}

\item{lwd}{number line width}
}
\description{
Basic plotting framework for EGRET dot plots. Graphical parameters default to values that work well with most plots, but all can be re-assigned.
See ?par for complete definitions of most optional input variables.
}
\examples{
x <- c(1,2,3,4,5,6)
y <- c(1,3,4,3.3,4.4,7)
xlim <- c(min(x)*.75,max(x)*1.25)
ylim <- c(0,1.25*max(y))
xlab <- "Date"
ylab <- "Concentration"
xTicks <- pretty(xlim)
yTicks <- pretty(ylim)
genericEGRETDotPlot(x=x, y=y, 
                    xlim=xlim, ylim=ylim,
                    xlab=xlab, ylab=ylab,
                    xTicks=xTicks, yTicks=yTicks,
                    plotTitle="Test"
)
yBottom <- 0
yLow <- c(NA,3,4,3.3,4,7)
yHigh <- c(1,3,4,3.3,5,NA)
Uncen <- c(0,1,1,1,0,0)
censoredSegments(yBottom=yBottom,yLow=yLow,yHigh=yHigh,x=x,Uncen=Uncen)
}
\seealso{
\code{\link[graphics]{segments}}
}

