% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELISAplate.R
\name{combineData}
\alias{combineData}
\title{Combine elisa_batch data}
\usage{
combineData(eb1, eb2)
}
\arguments{
\item{eb1}{list of elisa_batch data}

\item{eb2}{list of elisa_batch data}
}
\value{
a list of elisa_batch data combining the two input lists (sorted);
}
\description{
Combine the two lists of elisa_batch data.
}
\details{
When combining, we not only concatenate the two data sets, 
	but also combine batches, meaning the two 
	batches with same batch ID will be merged into one. 
	We will not merge the runs. Therefore, same batch from different
	list will always have different runs. It is the user's 
	responsibility to make sure the runs are different.
}
\examples{
#R code to run 5-parameter logistic regression on ELISA data
#load the library
library(ELISAtools)

#get file folder
dir_file<-system.file("extdata", package="ELISAtools")

batches<-loadData(file.path(dir_file,"design.txt"))

#make a guess for the parameters, the other two parameters a and d 
#will be estimated based on data.
model<-"5pl"
pars<-c(7.2,0.5, 0.015) #5pl inits
names(pars)<-c("xmid", "scal", "g")

#do fitting. model will be written into data set.
batches<-runFit(pars=pars,  batches=batches, refBatch.ID=1, model=model  )

#call to do predications based on the model.
batches<-predictAll(batches);

batches.old<-batches;

#now suppose want to join/combine the two batches, old and new 
batches.com<-combineData(batches.old, batches);

}
\seealso{
\code{\link{elisa_batch-class}} \code{\link{loadData}} \code{\link{saveDB}}
}
