% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELMBJEN.R
\name{ELMBJEN}
\alias{ELMBJEN}
\title{ELMBJEN}
\usage{
ELMBJEN(x, y, mtry = floor(sqrt(ncol(x))), trlength = 100,
  Regularization_coefficient = 10000, Kernel_type = "lin_kernel",
  Kernel_para = c(2, 1))
}
\arguments{
\item{x}{The covariates(predictor variables) of training data.}

\item{y}{Survival time and censored status of training data. Must be a Surv  \code{survival} object}

\item{mtry}{The number of covariates(predictor variables) used in each base ELM model. Default is the square root of the number of all avaibable covariates.}

\item{trlength}{The ensemle size (the number of base ELM survival models). Default is 100.}

\item{Regularization_coefficient}{Ridge or Tikhonov regularization parameter. Default is 10000. Also known as \eqn{C} in the ELM paper.}

\item{Kernel_type}{Type of kernel matrix. Currently four options avaibable. "RBF_kernel",a RBF kernel;"lin_kernel" , a linear kernel;"poly_kernel" ,a polynomial kernel;"sigmoid_kernel", a sigmoid kernel. Default is "lin_kernel".}

\item{Kernel_para}{Parameters for different types of kernels. A single value for RBF and linear kernels. A vector for polynomial and sigmoid kernels and progam stops if only a single value is supplied. However, if the vector of values is supplied in the cases of RBF and liner kernels, only the first value will be used. Default is a vector value "c(2,1)"}
}
\value{
Object of class \code{ELMSurvEN} with elements
  \tabular{ll}{
      \code{elmsurvfit}    \tab  A list of base models \code{ELMBJ} of size \code{trlength}. To retrieve a particular base model: use  elmsurvfit[[i]], where i takes values between 1 and \code{trlength} \cr
      \code{colindexes} \tab Covaraite subspace index. \cr
      \code{trlength} \tab Number of bases models trained. \cr
  }
}
\description{
A Survival Ensemble of Extreme Learning Machine Using the Buckley-James estimator
}
\examples{
set.seed(123)
require(ELMSurv)
require(survival)
## Survival Ensemble of ELM  with default settings
#Lung DATA
data(lung)
lung=na.omit(lung)
lung[,3]=lung[,3]-1
n=dim(lung)[1]
L=sample(1:n,ceiling(n*0.5))
trset<-lung[L,]
teset<-lung[-L,]
rii=c(2,3)
elmsurvmodel=ELMBJEN(x=trset[,-rii],y=Surv(trset[,rii[1]], trset[,rii[2]]))
# Get the 1th base model
firstbasemodel=elmsurvmodel$elmsurvfit[[1]]
}
\references{
\itemize{
  \item Hong Wang et al (2018). A Survival Ensemble of Extreme Learning Machine. Applied Intelligence, DOI:10.1007/s10489-017-1063-4.
 }
}
\seealso{
\code{\link{ELMBJ}}
}
\author{
Hong Wang
}
