% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{model_averaging}
\alias{model_averaging}
\title{Model Averaging}
\usage{
model_averaging(IC_for, IC_against)
}
\arguments{
\item{IC_for}{A numeric vector or the output of \code{compare}}

\item{IC_against}{A numeric vector or the output of \code{compare}}
}
\value{
A \code{data.frame} with the following columns:
\describe{
\item{\code{wFor}}{The aggregated weight of the models in favor.}
\item{\code{wAgainst}}{The aggregated weight of the models against.}
\item{\code{Factor}}{The Bayes factor (ratio of \code{wFor} to \code{wAgainst}).}
}
If \code{IC_for} is a data frame, a matrix with rows corresponding to each IC measure is returned.
}
\description{
Computes model weights and a Bayes factor by comparing two groups of models based on their
Information Criterion (IC) values. The function works with either numeric vectors or data
frames containing multiple IC measures (e.g., MD, BPIC, DIC).
}
\details{
When provided with numeric vectors, it computes the weights for the two groups by first
converting the IC values into relative weights and then normalizing them. When provided with
a data frame, it assumes that the data frame is the output of a call to \code{compare}
and applies averaging to each IC metric
}
\examples{
# First set up some example models (normally these would be alternative models)
samples_LNR2 <- subset(samples_LNR, length.out = 45)
samples_LNR3 <- subset(samples_LNR, length.out = 40)
samples_LNR4 <- subset(samples_LNR, length.out = 35)

# Run compare on them, BayesFactor = F is set for speed.
ICs <- compare(list(S1 = samples_LNR, S2 = samples_LNR2,
                    S3 = samples_LNR3, S4 = samples_LNR4), BayesFactor = FALSE)

# Model averaging can either be done with a vector of ICs:
model_averaging(ICs$BPIC[1:2], ICs$BPIC[2:4])

# Or the output of compare:
model_averaging(ICs[1:2,], ICs[3:4,])

}
