% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust.EM.R
\name{robust.EM}
\alias{robust.EM}
\title{Extract robust end-members}
\usage{
robust.EM(em, limits, classunits, amount, l, mc_n, type = "mean",
  qt = c(0.25, 0.75), cores = 1, plot = FALSE, ...)
}
\arguments{
\item{em}{\code{List} of class \code{"EMMAgeo_empot"}, i.e. the outout of 
\code{model.em()} or \code{test.robustness()}, containing potential 
end-members, both in unscaled and rescaled version as well as further 
parameters.}

\item{limits}{\code{Numeric} matrix with two columns, defining the class 
limits for the robust end-members to calculate. The first column defines the 
lower limits, the second column the upper limits. End-members are organised 
in rows.}

\item{classunits}{\code{Numeric} vector, optional class units 
(e.g. micrometers or phi-units) of the same length as columns of \code{X}.}

\item{amount}{\code{Numeric} matrix with two columns, defining the minimum 
and maximum amount of the modal class for each end-member.}

\item{l}{\code{Numeric} scalar, weight transformation limit for 
modelling the average end-member output.}

\item{mc_n}{\code{Numeric} scalar, number of Monte Carlo simulations to 
estimate end-member scores uncertainty. The default setting is ten times the 
product of number of end-members and number of weight transformation limits. 
The latter is inherited from \code{model.em()}. To disable modelling of 
scores uncertainty, set \code{mc_n = 0}.}

\item{type}{\code{Character} scalar, type of oadings statistics. One out of 
\code{"mean"} and \code{"median"}. Default is \code{"mean"}.}

\item{qt}{\code{Numeric} vector of length two, quantiles to describe 
end-member loadings. Default is \code{c(0.25, 0.75)} (i.e., the quartile 
range).}

\item{cores}{\code{Numeric} scalar, number of CPU cores to be used for 
calculations. Only useful in multicore architectures. Default is \code{1} 
(single core).}

\item{plot}{\code{Logical} scalar, option for plot output. Default is 
\code{FALSE}.}

\item{\dots}{Additional arguments passed to \code{EMMA} and \code{plot}.}
}
\value{
\code{List} with statistic descriptions of end-member loadings 
and scores.
}
\description{
This function takes a list object with potential end-member loadings and 
extracts those with modes in specified limits to describe them by mean and
standard deviation and use these descriptions to propagate the uncertainties
to end-member scores.
}
\details{
The function is used to extract potential end-member loadings based on their
mode positions and, optionally the height of the mode class, and use them to 
infer mean and stanard deviation of all 
end-members that match the group criteria defined by \code{limits}. These 
information are then used to model the uncertainty of the corresponding
end-member scores. The function uses input from two preceeding approaches. 
In a compact protocol \code{model.em} delivers these data in a predefined 
way. In the extended protocol \code{test.robustness} does this.
}
\examples{

## Not run because of long computation time, compact protocol

## load example data set
# data(example_X)

## get weight transformation limit vector
# l <- get.l(X = X)

## get minimum and maximum number of end-members
# q <- get.q(X = X, l = l)

## get all potential model scenarios
# EM_pot <- model.EM(X = X, q = q, plot = TRUE)

## define end-member mode class limits
# limits <- cbind(c(61, 74, 95, 102), 
#                 c(64, 76, 100, 105))

## get robust end-members in the default way, with plot output
# rem <- robust.EM(em = EM_pot,
#                  limits = limits,
#                  plot = TRUE)
                    
## get robust end-members by only modelling uncertainty in loadings
# robust_EM <- robust.EM(em = EM_pot, 
# limits = limits, 
# plot = TRUE)
                    
}
\seealso{
\code{\link{robust.loadings}}, \code{\link{robust.scores}}
}
\author{
Michael Dietze, Elisabeth Dietze
}
\keyword{EMMA}
