% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnPCA.R
\name{Execute_nnPCA}
\alias{Execute_nnPCA}
\title{nnPCA methods to calculate EMT score}
\usage{
Execute_nnPCA(geneExp, geneList, dimension, score_names)
}
\arguments{
\item{geneExp}{A numeric matrix of gene expression values where rows represent genes and columns represent samples/cells.}

\item{geneList}{A list of signature gene sets. It should contain a column named `GeneName` which lists the genes to be used in the analysis.}

\item{dimension}{An integer specifying the number of principal components to compute (default is 1).}

\item{score_names}{A character vector specifying the names to assign to the columns of the returned data frame containing the scores (e.g., c('M1_score', 'M2_score')).}
}
\value{
A data frame containing sample/cell IDs and their respective EMT scores.
}
\description{
nnPCA methods to calculate EMT score
}
\examples{
library(curl)
url <- "https://zenodo.org/record/15213845/files/geneExp.rda"
destfile <- tempfile(fileext = ".rda")
download.file(url, destfile, mode = "wb")
load(destfile)
data(Panchy_et_al_E_signature)
library(nsprcomp)
Execute_nnPCA(geneExp, Panchy_et_al_E_signature, dimension=1, score_names='E_score')
nnPCA_Mscore <- Execute_nnPCA(
geneExp, 
Panchy_et_al_E_signature, 
dimension=2,
score_names=c('M1_score','M2_score')
)
}
