% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appPlots.R
\name{pcpPlot}
\alias{pcpPlot}
\title{A PCP plot of the data, residuals or hat values from regression fits}
\usage{
pcpPlot(data, fit, type = "Variables", npcpCols = 4, resDiff = F,
  absResid = F, sequential = F, selnum = NULL)
}
\arguments{
\item{data}{a data frame}

\item{fit}{a lm for the data frame}

\item{type}{one of "Variables", "Residuals", "Hatvalues"}

\item{npcpCols}{number of colours}

\item{resDiff}{difference residuals, TRUE or FALSE}

\item{absResid}{absolute residuals, TRUE or FALSE}

\item{sequential}{use sequential fits (TRUE) or drop1 fits (FALSE)}

\item{selnum}{row numbers of cases to be highlighted}
}
\value{
ggplot
}
\description{
A PCP plot of the data, residuals or hat values from regression fits
}
\examples{
f <- lm(mpg ~ wt+hp+disp, data=mtcars)
pcpPlot(mtcars, f, type="Residuals")
}
