% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EValue.R
\name{threshold}
\alias{threshold}
\title{Compute E-value for single value of risk ratio}
\usage{
threshold(x, true = 1)
}
\arguments{
\item{x}{The risk ratio}

\item{true}{The true RR to which to shift the observed point estimate. Typically set to 1 to consider a null true effect.}
}
\description{
Computes E-value for a single value of the risk ratio. Users should typically call the 
relevant \code{evalues.XX()} function rather than this internal function.
}
\examples{
## Example 1
## Hammond and Holl (1958 JAMA) Data
## Two by Two Table
#          Lung Cancer    No Lung Cancer
# Smoker    397            78557
# Nonsmoker 51             108778

# first get RR and CI bounds
twoXtwoRR(397, 78557, 51, 108778)

# then compute E-values
evalues.RR(10.729780, 8.017457, 14.359688)
}
