% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.dom_af.R
\name{eco.dom_af}
\alias{eco.dom_af}
\title{Compute allele frequencies for dominant data using different methods}
\usage{
eco.dom_af(x, method = c("zhivor", "zhivonu", "rawfreq"))
}
\arguments{
\item{x}{ecopop or genpop object, or matrix/data.frame with allele frequencies}

\item{method}{Method used to compute the allelic frequencies. 
Can be one of 'zhivor' ( Zhivotovsky 1999, with uniform prior),  
'zhivonu' (Zhivotovsky 1999, with non uniform prior), 
'rawfreq' (square root method).}
}
\description{
Compute allele frequencies for dominant data using different methods
}
\examples{
\dontrun{
data(eco.test)
my_ecopop <- ecogen2ecopop(eco, "pop")
eco.dom_af(my_ecopop)
}
}
\references{
Zhivotovsky, L. A. (1999). Estimating population structure in diploids 
with multilocus dominant DNA markers. Molecular Ecology, 8:907-913.
}
\author{
Juan Vilardi \email{vilardi@ege.fcen.uba.ar}
}
