% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/algorithms.R
\name{ra4}
\alias{ra4}
\title{RA4 Niche Overlap Randomization Algorithm}
\usage{
ra4(speciesData = matrix(rpois(80, 1), nrow = 10))
}
\arguments{
\item{speciesData}{a resource utilization matrix (rows = species, columns = discrete
resource states) filled with non-negative real numbers.}
}
\value{
Returns a random utilization matrix with the same dimensions as the
input matrix.
}
\description{
Randomizes a numeric utilization matrix speciesData by
reshuffling the non-zero elements within each row.
}
\details{
The resource utilization matrix (rows = species, columns = discrete
resource categories) may include zeroes, but no negative numbers or missing
values. Relative resource within a species is first calculated, so the rows
need not sum to 1.0.
}
\note{
This algorithm is similar to RA3, but adds the additional constraint of
retaining the positions of all of the zero elements of the matrix, and
reshuffling only the non-zero elements of the matrix within each row. It is
more conservative than RA3, but has a low Type I error rate, and, along with
RA3, is recommended for null model analysis of niche overlap.
}
\examples{
ranUtil <- ra4(speciesData=matrix(rpois(40,0.5),nrow=8))
}
\references{
Winemiller, K.O. and E.R. Pianka. 1990. Organization in natural
assemblages of desert lizards and tropical fishes. Ecological Monographs
60: 27-55.
}

