% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rq.sdf.R
\name{rq.sdf}
\alias{rq.sdf}
\alias{rq}
\title{EdSurvey Quantile Regression Models}
\usage{
rq.sdf(formula, data, tau = 0.5, weightVar = NULL, relevels = list(),
  jrrIMax = 1, omittedLevels = TRUE, defaultConditions = TRUE,
  recode = NULL, returnNumberOfPSU = FALSE, ...)
}
\arguments{
\item{formula}{a \ifelse{latex}{\code{formula}}{\code{\link[stats]{formula}}} for the
quantile regression model. See \ifelse{latex}{\code{rq} in the \code{quantreg} package}{\code{\link[quantreg]{rq}}}.
If \emph{y} is left blank, the default subject scale or subscale variable
will be used. (You can find the default using
\code{\link{showPlausibleValues}}.)
If \emph{y} is a variable for a subject scale or subscale (one of the
names shown by \code{\link{showPlausibleValues}}),
then that subject scale or subscale is used.}

\item{data}{an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame},
or an \code{edsurvey.data.frame.list}}

\item{tau}{the quantile to be estimated. The value could be set between 0 and 1 with a default of 0.5.}

\item{weightVar}{a character indicating the weight variable to use (see Details).
The \code{weightVar} must be one of the weights for the
\code{edsurvey.data.frame}. If \code{NULL}, it  uses the default
for the \code{edsurvey.data.frame}.}

\item{relevels}{a list. Used to change the contrasts from the
default treatment contrasts to the treatment contrasts with a chosen omitted
group (the reference group). The name of each element should be the variable name, and the value 
should be the group to be omitted (the reference group).}

\item{jrrIMax}{when using the jackknife variance estimation method, the default estimation option, \code{jrrIMax=1}, uses the 
sampling variance from the first plausible value as the component for sampling variance estimation. The \eqn{V_{jrr}} 
term (see Details) can be estimated with any number of plausible values, and values larger than the number of 
plausible values on the survey (including \code{Inf}) will result in all of the plausible values being used. 
Higher values of \code{jrrIMax} lead to longer computing times and more accurate variance estimates.}

\item{omittedLevels}{a logical value. When set to the default value of \code{TRUE}, drops
those levels of all factor variables that are specified
in an \code{edsurvey.data.frame}. Use \code{print} on an
\code{edsurvey.data.frame} to see the omitted levels.}

\item{defaultConditions}{a logical value. When set to the default value of \code{TRUE}, uses
the default conditions stored in an \code{edsurvey.data.frame}
to subset the data. Use \code{print} on an
\code{edsurvey.data.frame} to see the default conditions.}

\item{recode}{a list of lists to recode variables. Defaults to \code{NULL}. Can be set as
\code{recode=}\code{list(}\code{var1} \code{=} \code{list(}\code{from=} 
\code{c("a",} \code{"b",} \code{"c"),} \code{to=} \code{"d"))}. See Examples.}

\item{returnNumberOfPSU}{a logical value set to \code{TRUE} to return the number of 
primary sampling units (PSUs)}

\item{...}{additional parameters passed from \ifelse{latex}{\code{rq}}{\code{\link[quantreg]{rq}}}}
}
\value{
An \code{edsurvey.rq} with the following elements:
   \item{call}{the function call}
   \item{formula}{the formula used to fit the model}
   \item{tau}{the quantile to be estimated}
   \item{coef}{the estimates of the coefficients}
   \item{se}{the standard error estimates of the coefficients}
   \item{Vimp}{the estimated variance from uncertainty in the scores (plausible value variables)}
   \item{Vjrr}{the estimated variance from sampling}
   \item{M}{the number of plausible values}
   \item{varm}{the variance estimates under the various plausible values}
   \item{coefm}{the values of the coefficients under the various plausible values}
   \item{coefmat}{the coefficient matrix (typically produced by the summary of a model)}
   \item{weight}{the name of the weight variable}
   \item{npv}{the number of plausible values}
   \item{njk}{the number of jackknife replicates used; set to \code{NA} when Taylor series variance
   estimates are used}
}
\description{
Fits a quantile regression model that uses weights and variance estimates appropriate for the data.
}
\details{
The function computes an estimate on the tau-th conditional quantile function of the response, 
given the covariates, as specified by the formula argument. Like \code{lm.sdf()}, the  
function presumes a linear specification for the quantile regression model (i.e., that the 
formula defines a model that is linear in parameters). Unlike \code{lm.sdf()}, Jackknife is the
only applicable variance estimation method used by the function.

For further details on quantile regression models and how they are implemented in R, see Koenker
 & Bassett (1978), Koenker (2005), and the vignette from the \code{quantreg} package 
(accessible by \code{vignette("rq",package="quantreg")}), on which this function is 
built.

For further details on how left-hand side variables, survey sampling weights, and estimates 
variances are correctly handled, see \code{?lm.sdf} or the
\href{https://www.air.org/sites/default/files/EdSurvey-Statistics.pdf}{Statistics vignette}.
}
\examples{
\dontrun{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# conduct quantile regression at a given tau value (by default, tau is set to be 0.5) 
rq1 <- rq.sdf(composite ~ dsex + b017451, data=sdf, tau = 0.8)
summary(rq1)
}
}
\references{
Binder, D. A. (1983). On the variances of asymptotically normal estimators from complex surveys. 
\emph{International Statistical Review}, \emph{51}(3), 279--292. 

Johnson, E. G., & Rust, K. F. (1992). Population inferences and variance estimation for NAEP 
data. \emph{Journal of Education Statistics}, \emph{17}(2), 175--190.

Koenker, R. W., & Bassett, G. W. (1978). Regression quantiles, \emph{Econometrica}, 46, 33--50.

Koenker, R. W. (2005). \emph{Quantile regression}. Cambridge, UK; Cambridge University Press.

Rubin, D. B. (1987). \emph{Multiple imputation for nonresponse in surveys}. New York, NY: Wiley.
}
\seealso{
\ifelse{latex}{\code{rq}}{\code{\link[quantreg]{rq}}}
}
\author{
Trang Nguyen, Paul Bailey, and Yuqi Liao
}
