% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadPIAAC.R
\name{downloadPIAAC}
\alias{downloadPIAAC}
\title{Download and Unzip PIAAC Files}
\usage{
downloadPIAAC(root, cycle = 1, cache = FALSE, verbose = TRUE)
}
\arguments{
\item{root}{a character string indicating the directory where the PIAAC data should
be stored. Files are placed in a folder named PIAAC/cycle [cycle number].}

\item{cycle}{a numeric value indicating the assessment cycle to download.
Valid cycle is 1 only.}

\item{cache}{a logical value set to process and cache the text (.txt) version of files.
This takes a very long time but saves time for future uses of 
the data. Default value is \code{FALSE}.}

\item{verbose}{a logical value to either print or suppress status message output.
The default value is \code{TRUE}.}
}
\description{
Uses an Internet connection to download PIAAC data to a
             computer. Data come from the OECD website.
}
\examples{
\dontrun{
# download all available data for PIAAC round 1 to "C:/PIAAC/Round 1" folder
# root argument will vary by operating system conventions
downloadPIAAC(root="C:/")
}
}
\author{
Paul Bailey and Trang Nguyen
}
