% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readNAEP.r
\name{readNAEP}
\alias{readNAEP}
\title{Connect to NAEP Data}
\usage{
readNAEP(
  path,
  defaultWeight = "origwt",
  defaultPvs = "composite",
  omittedLevels = c("Multiple", NA, "Omitted"),
  frPath = NULL,
  xmlPath = NULL
)
}
\arguments{
\item{path}{a character value indicating the full filepath location and name
of the (.dat) data file}

\item{defaultWeight}{a character value that indicates the default weight
specified in the resulting \code{edsurvey.data.frame}.
Default value is \code{origwt} if not specified.}

\item{defaultPvs}{a character value that indicates the default plausible value
specified in the resulting \code{edsurvey.data.frame}.
Default value is \code{composite} if not specified.}

\item{omittedLevels}{a character vector indicating which factor levels/labels
should be excluded. When set to the default value of
\code{c('Multiple',NA,'Omitted')}, adds the vector to
the \code{edsurvey.data.frame}.}

\item{frPath}{a character value indicating the file location of the \code{.fr2}
parameter layout file included with the data companion to
parse the specified \code{path} data file.
The default value of \code{NULL} will attempt to search the parent directory for the corresponding \code{.fr2} file for the specified \code{path} data file.}

\item{xmlPath}{a character value indicating the file path of the \code{.xml} parameter layout file included as part of the NAEPEX companion. This file provides necessary
information required to read and parse the (.dat) data file. The default value of \code{NULL} will attempt to search
the parent directory for the corresponding \code{.xml} file for the specified \code{path} data file.}
}
\value{
An \code{edsurvey.data.frame} for a NAEP data file.
}
\description{
Opens a connection to a Main NAEP, or Long-Term Trend NAEP data file residing
             on the disk. Returns an \code{edsurvey.data.frame} with
             information about the file and data.
}
\details{
The \code{frPath} file layout information will take precedence over the \code{xmlPath} file when the \code{xmlPath} is not explicitly set, or when the \code{xmlPath} file cannot be located.

The \code{readNAEP} function includes both scaled scores and theta scores, with the latter having names ending in \code{\_theta}.

When a NAEP administration includes a linking error variable those variables are included and end in \code{_linking}.
When present, simply use the \code{_linking} version of a variable to get a standard error estimate that includes linking error.

This function supports both the Main NAEP data files, and Long-Term Trend NAEP data files.
A table outlining the differences can be found on the \href{https://nces.ed.gov/nationsreportcard/about/ltt_main_diff.aspx}{NAEP Nations Report Card website}.
}
\examples{
\dontrun{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))
sdf

# To read in an NCES file first set the directory to the /Data subfolder,
# then read in the appropriate .dat file:
setwd("location/of/Data")
sdf <- readNAEP(path="M36NT2PM.dat")

# Or read in the .dat file directly through the folder pathway:
sdf <- readNAEP(path="location/of/Data/M36NT2PM.dat")
}
}
\seealso{
\code{\link{edsurvey.data.frame}} \code{\link{getData}}
}
\author{
Tom Fink and Ahmad Emad
}
