% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elr_aggregated_effects.R
\name{computeAggregatedEffects}
\alias{computeAggregatedEffects}
\title{Compute Aggregated Effects}
\usage{
computeAggregatedEffects(obj, agg.subset)
}
\arguments{
\item{obj}{Object of class \code{effectlite}.}

\item{agg.subset}{Vector of integers indicating the row numbers of the 
original dataset for the subset used to compute the aggregated effect}
}
\value{
Object of class \code{"data.frame"}.
}
\description{
Computes aggregates of conditional effects for a subset of the original dataset 
based on a fitted EffectLiteR model.
}
\examples{
m1 <- effectLite(y="dv", z=c("z1"), k=c("k1"), x="x", 
control="control", data=example01, fixed.cell=TRUE, fixed.z=TRUE)
newdata <- data.frame(k1=NA, z1=1)
agg.subset <- autoSelectSubset(m1, newdata)
computeAggregatedEffects(m1, agg.subset)
}
