% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed.R
\name{EmbedSOM}
\alias{EmbedSOM}
\title{Process the cells with SOM into a nice embedding}
\usage{
EmbedSOM(data = NULL, map = NULL, fsom = NULL, smooth = NULL,
  k = NULL, adjust = NULL, importance = NULL, coordsFn = NULL,
  coords = NULL, emcoords = NULL, emcoords.pow = 1, parallel = F,
  threads = if (parallel) 0 else 1)
}
\arguments{
\item{data}{Data matrix with points that optionally overrides the one from \code{fsom$data}}

\item{map}{Map object in FlowSOM format, to optionally override \code{fsom$map}}

\item{fsom}{FlowSOM object with a built SOM (used if data or map are missing)}

\item{smooth}{Produce smoother (positive values) or more rough approximation (negative values).}

\item{k}{How many neighboring landmarks (e.g. SOM nodes) to take into the whole computation}

\item{adjust}{How much non-local information to remove from the approximation}

\item{importance}{Scaling of the landmarks, will be used to scale the incoming data (should be same as used for training the SOM or to select the landmarks)}

\item{coordsFn}{A coordinates-generating function (e.g. \code{\link[=tSNECoords]{tSNECoords()}}) that overrides the existing \code{map$grid}.}

\item{coords}{A matrix of embedding-space coordinates that correspond to \code{map$codes} (i.e. the "embedded landmarks"). Overrides \code{map$grid} if not NULL.}

\item{emcoords}{Provided for backwards compatibility, will be removed. Use \code{coords} and \code{coordsFn} instead.}

\item{emcoords.pow}{Provided for backwards compatibility, will be removed. Use a parametrized \code{coordsFn} instead.}

\item{parallel}{Boolean flag whether the computation should be parallelized (this flag is just a nice name for \code{threads} and does not do anything directly -- default FALSE sets threads=1, TRUE sets threads=0)}

\item{threads}{Number of threads used for computation, 0 chooses hardware concurrency, 1 (default) turns off parallelization.}
}
\value{
matrix with 2D or 3D coordinates of the embedded \code{data}, depending on the \code{map}
}
\description{
Process the cells with SOM into a nice embedding
}
\examples{
d <- cbind(rnorm(10000), 3*runif(10000), rexp(10000))
colnames(d) <- paste0("col",1:3)
map <- EmbedSOM::SOM(d, xdim=10, ydim=10)
e <- EmbedSOM::EmbedSOM(data=d, map=map)
EmbedSOM::PlotEmbed(e, data=d, 'col1', pch=16)
}
