% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotForest}
\alias{plotForest}
\title{Create a forest plot}
\usage{
plotForest(logRr, seLogRr, names, xLabel = "Relative risk", fileName = NULL)
}
\arguments{
\item{logRr}{A numeric vector of effect estimates on the log scale}

\item{seLogRr}{The standard error of the log of the effect estimates. Hint: often the standard
error = (log(<lower bound 95 percent confidence interval>) - log(<effect
estimate>))/qnorm(0.025)}

\item{names}{A vector containing the names of the drugs or outcomes}

\item{xLabel}{The label on the x-axis: the name of the effect estimate}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'. See the
function \code{ggsave} in the ggplot2 package for supported file formats.}
}
\value{
A Ggplot object. Use the \code{ggsave} function to save to file.
}
\description{
\code{plotForest} creates a forest plot of effect size estimates.
}
\details{
Creates a forest plot of effect size estimates (ratios). Estimates that are significantly different
from 1 (alpha = 0.05) are marked in orange, others are marked in blue.
}
\examples{
data(sccs)
negatives <- sccs[sccs$groundTruth == 0, ]
plotForest(negatives$logRr, negatives$seLogRr, negatives$drugName)

}

