% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epinow.R
\name{epinow}
\alias{epinow}
\title{Real-time Rt Estimation, Forecasting and Reporting}
\usage{
epinow(
  reported_cases,
  generation_time,
  delays = delay_opts(),
  truncation = trunc_opts(),
  rt = rt_opts(),
  backcalc = backcalc_opts(),
  gp = gp_opts(),
  obs = obs_opts(),
  stan = stan_opts(),
  horizon = 7,
  CrIs = c(0.2, 0.5, 0.9),
  return_output = FALSE,
  output = c("samples", "plots", "latest", "fit", "timing"),
  target_folder = NULL,
  target_date,
  forecast_args = NULL,
  logs = tempdir(),
  id = "epinow",
  verbose = interactive()
)
}
\arguments{
\item{reported_cases}{A data frame of confirmed cases (confirm) by date (date). confirm must be integer and date must be
in date format.}

\item{generation_time}{A list containing the mean, standard deviation of the mean (mean_sd),
standard deviation (sd), standard deviation of the standard deviation and the maximum allowed value for the
generation time (assuming a gamma distribution).}

\item{delays}{A call to \code{delay_opts} defining delay distributions and options. See the documentation of \code{delay_opts}
and the examples below for details.}

\item{truncation}{\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#experimental'><img src='figures/lifecycle-experimental.svg' alt='Experimental lifecycle'></a>}}{\strong{Experimental}} A list of options as generated by \code{trunc_opts()}
defining the truncation of observed data. Defaults to \code{trunc_opts()}. See \code{estimate_truncation()}
for an approach to estimating truncation from data.}

\item{rt}{A list of options as generated by \code{rt_opts()} defining Rt estimation.
Defaults to \code{rt_opts()}. Set to \code{NULL} to switch to using  back calculation
rather than generating infections using Rt.}

\item{backcalc}{A list of options as generated by \code{backcalc_opts()} to define the
back calculation. Defaults to \code{backcalc_opts()}.}

\item{gp}{A list of options as generated by \code{gp_opts()} to define the
Gaussian process. Defaults to \code{gp_opts()}.Set to NULL to disable the
Gaussian process.}

\item{obs}{A list of options as generated by \code{obs_opts()} defining the
observation model. Defaults to \code{obs_opts()}.}

\item{stan}{A list of stan options as generated by \code{stan_opts()}. Defaults to \code{stan_opts()}. Can be used to override
\code{data}, \code{init}, and \code{verbose} settings if desired.}

\item{horizon}{Numeric, defaults to 7. Number of days into the future to forecast.}

\item{CrIs}{Numeric vector of credible intervals to calculate.}

\item{return_output}{Logical, defaults to FALSE. Should output be returned, this automatically updates to TRUE
if no directory for saving is specified.}

\item{output}{A character vector of optional output to return. Supported options are samples ("samples"),
plots ("plots"), the run time ("timing"), copying the dated folder into a latest folder (if \code{target_folder} is not null
\itemize{
\item set using "latest"), and the stan fit ("fit"). The default is to return all options. This argument uses partial matching so for example passing "sam" will lead to samples
being reported.
}}

\item{target_folder}{Character string specifying where to save results (will create if not present).}

\item{target_date}{Date, defaults to maximum found in the data if not specified.}

\item{forecast_args}{A list of arguments to pass to \code{forecast_infections()}. Unless at a minimum a \code{forecast_model} is passed
tin his list then \code{forecast_infections} will be bypassed.}

\item{logs}{Character path indicating the target folder in which to store log
information. Defaults to the temporary directory if not specified. Default logging
can be disabled if \code{logs} is set to NULL. If specifying a custom logging setup then
the code for \code{setup_default_logging} and the \code{setup_logging} function are a sensible
place to start.}

\item{id}{A character string used to assign logging information on error. Used by \code{regional_epinow}
to assign errors to regions. Alter the default to run with error catching.}

\item{verbose}{Logical, defaults to \code{TRUE} when used interactively and otherwise \code{FALSE}. Should verbose debug progress messages be printed. Corresponds to the "DEBUG" level from
\code{futile.logger}. See \code{setup_logging} for more detailed logging options.}
}
\value{
A list of output from estimate_infections, forecast_infections,  report_cases, and report_summary.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}
This function wraps the functionality of \code{estimate_infections()} and \code{forecast_infections()} in order
to estimate Rt and cases by date of infection, forecast into these infections into the future. It also contains
additional functionality to convert forecasts to date of report and produce summary output useful for reporting
results and interpreting them. See \href{https://gist.github.com/seabbs/163d0f195892cde685c70473e1f5e867}{here} for an
example of using \code{epinow} to estimate Rt for Covid-19 in a country from the ECDC data source.
}
\examples{
\donttest{
#set number of cores to use
options(mc.cores = ifelse(interactive(), 4, 1))
# construct example distributions
generation_time <- get_generation_time(disease = "SARS-CoV-2", source = "ganyani")
incubation_period <- get_incubation_period(disease = "SARS-CoV-2", source = "lauer")
reporting_delay <- list(mean = convert_to_logmean(3, 1), 
                        mean_sd = 0.1,
                        sd = convert_to_logsd(3, 1), 
                        sd_sd = 0.1, 
                        max = 10)

# example case data
reported_cases <- example_confirmed[1:40] 

# estimate Rt and nowcast/forecast cases by date of infection
out <- epinow(reported_cases = reported_cases, generation_time = generation_time,
              rt = rt_opts(prior = list(mean = 2, sd = 0.1)),
              delays = delay_opts(incubation_period, reporting_delay))
# summary of the latest estimates
summary(out)     
# plot estimates        
plot(out)

# summary of R estimates
summary(out, type = "parameters", params = "R")
}
}
\seealso{
estimate_infections simulate_infections forecast_infections regional_epinow
}
