% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{calc_CrIs}
\alias{calc_CrIs}
\title{Calculate Credible Intervals}
\usage{
calc_CrIs(samples, summarise_by = c(), CrIs = c(0.2, 0.5, 0.9))
}
\arguments{
\item{samples}{A data.table containing at least a value variable}

\item{summarise_by}{A character vector of variables to group by.}

\item{CrIs}{Numeric vector of credible intervals to calculate.}
}
\value{
A data.table containing the \code{summarise_by} variables and the specified lower and upper
credible intervals
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Adds symmetric credible intervals based on quantiles.
}
\examples{
samples <- data.frame(value = 1:10, type = "car")
# add credible intervals
calc_CrIs(samples)
# add 90\% credible interval grouped by type
calc_CrIs(samples, summarise_by = "type")
}
