% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{collapse}
\alias{collapse}
\alias{collapse.dist_spec}
\title{Collapse nonparametric distributions in a <dist_spec>}
\usage{
\method{collapse}{dist_spec}(x, ...)
}
\arguments{
\item{x}{A \verb{<dist_spec>}}

\item{...}{ignored}
}
\value{
A \verb{<dist_spec>} where consecutive nonparametric distributions
have been convolved
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This convolves any consecutive nonparametric distributions contained
in the <dist_spec>.
}
\examples{
# A fixed gamma distribution with mean 5 and sd 1.
dist1 <- Gamma(mean = 5, sd = 1, max = 20)

# An uncertain lognormal distribution with meanlog and sdlog normally
# distributed as Normal(3, 0.5) and Normal(2, 0.5) respectively
dist2 <- LogNormal(
  meanlog = Normal(3, 0.5),
  sdlog = Normal(2, 0.5),
  max = 20
)

# The maxf the sum of two distributions
collapse(discretise(dist1 + dist2, strict = FALSE))
}
