% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AER_seasonality_graph.R
\name{plotSeasonality}
\alias{plotSeasonality}
\title{Seasonality line graph}
\usage{
plotSeasonality(data, xvar = "TimeCode", yvar = "N",
  min4years = "Min4Years", max4years = "Max4Years",
  mean4years = "Mean4Years", year = 2016)
}
\arguments{
\item{data}{dataframe containing the variables to plot}

\item{xvar}{character string, name of the time variable on the x-axis in quotes
(default \code{"TimeCode"})}

\item{yvar}{character string, name of the variable to plot on the y-axis in quotes
(default \code{"N"}), number of cases by month in the reference year (green solid line)}

\item{min4years}{character string, name of the variable to plot in quotes including the minimum
number of cases by month over the past 4 years (default \code{"Min4Years"})}

\item{max4years}{character string, name of the variable to plot in quotes including the maximum
number of cases by month over the past 4 years (default \code{"Max4Years"})}

\item{mean4years}{character string, name of the variable to plot in quotes including the mean of the
number of cases by month over the past 4 years (default \code{"Mean4Years"})}

\item{year}{numeric, year to produce the graph for (default \code{2016}).}
}
\description{
This function draws a line graph describing the seasonality of the selected disease
over the past 5 years. \cr
The graph includes the distribution of cases, by month, over the past five years, with:
\itemize{
   \item{\code{yvar}: }{The number of cases by month in the reference year (green solid line)}
   \item{\code{mean4years}: }{The mean number of cases by month in the four previous years (grey dashed line)}
   \item{\code{min4years}: }{The minimum number of cases by month in the four previous years (grey area)}
   \item{\code{max4years}: }{The maximum number of cases by month in the four previous years (grey area)}
}
Expects aggregated data and pre-calculated min, max and mean figures.
}
\seealso{
Global function: \code{\link{getSeason}}  \cr
Required Packages: \code{\link{ggplot2}}
}
\keyword{seasonality}
