% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EpistemicGameTheory.R
\name{esdc}
\alias{esdc}
\title{Eliminating strictly dominated choices}
\usage{
esdc(n, m, A, choices.A, B, choices.B, iteration)
}
\arguments{
\item{n}{an integer representing the number of choices of player 1}

\item{m}{an integer representing the number of choices of player 2}

\item{A}{an nxm matrix representing the payoff matrix of player 1}

\item{choices.A}{a vector of length n representing the names of player 1's choices}

\item{B}{an nxm matrix representing the payoff matrix of player 2}

\item{choices.B}{a vector of length m representing the names of player 2's choices}

\item{iteration}{an integer representing the iteration number of algorithm}
}
\value{
The reduced matrices of players' that are obtained after eliminating strictly dominated choices
}
\description{
This function eliminates strictly dominated choices.
}
\details{
This function works for the games with two players.
}
\examples{
a=4
b=4
pay.A=matrix(c(0,3,2,1,4,0,2,1,4,3,0,1,4,3,2,0),4,4)
ch.A=c("Blue","Green","Red","Yellow")
pay.B=matrix(c(5,4,4,4,3,5,3,3,2,2,5,2,1,1,1,5),4,4)
ch.B=c("Blue","Green","Red","Yellow")
iter=5
esdc(a,b,pay.A,ch.A,pay.B,ch.B,iter)
}
\author{
Bilge Baser
}
