% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_Etfs_List_bis.R
\name{EN_Etfs_List_bis}
\alias{EN_Etfs_List_bis}
\title{Get the list of Etfs quoted on Euronext markets (bis)}
\usage{
EN_Etfs_List_bis(target_page = 1)
}
\arguments{
\item{target_page}{Target page to retrieve. It can be a numerical value, 'Max' to designate the last pages, or the default value is 1 (which means first page).

Unlike the function \code{\link{EN_Etfs_List}}, this function allows you to specify a target page to retrieve from the list
of Etfs. For example, \code{EN_Etfs_List_bis(5)} fetches only the fifth page of the Etfs list, providing a more granular
control over the data retrieval process.}
}
\value{
A data frame containing information about Etfs, including name, ticker, ISIN code, market, last price, percentage change, and URL.
}
\description{
This function retrieves information about Etfs quoted on Euronext markets.
}
\examples{


dt_ = EN_Etfs_List_bis(5) # To show only the 5th page of Etfs (100 Etfs)
print(dt_)

dt_1 = EN_Etfs_List_bis() # To show the 1st page of Etfs List
tail(dt_1)
\donttest{
dt_max = EN_Etfs_List_bis("Max") #To show only the last page of quoted Etfs
head(dt_max)
}

}
\seealso{
\code{\link{EN_Stocks_List}} to get the list tickers infos quoted on a given Euronext Stock,
\code{\link{EN_Bonds_List}} for Bonds list,  \code{\link{EN_Indices_List}} for Indexes list,
\code{\link{EN_GetISIN_Etf}}  to get the ADN(Isin and Market indentifier) of a givin Etf.

Other Infos Retrieval: 
\code{\link{EN_Bonds_List_bis}()},
\code{\link{EN_Bonds_List}()},
\code{\link{EN_Etfs_List}()},
\code{\link{EN_Funds_List}()},
\code{\link{EN_GetISIN_B}()},
\code{\link{EN_GetISIN_Etf}()},
\code{\link{EN_GetISIN_F}()},
\code{\link{EN_Get_News}()},
\code{\link{EN_Indices_List}()},
\code{\link{EN_Stocks_List}()},
\code{\link{En_Market.Sumarry}()}
}
\concept{Infos Retrieval}
