% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesianSynthesis.R
\name{approximateHierarchicalNormalPosterior}
\alias{approximateHierarchicalNormalPosterior}
\title{Approximate Bayesian posterior for hierarchical Normal model}
\usage{
approximateHierarchicalNormalPosterior(
  likelihoodProfiles,
  chainLength = 1100000,
  burnIn = 1e+05,
  subSampleFrequency = 100,
  effectPriorMean = 0,
  effectPriorSd = 0.5,
  nu0 = 1,
  sigma0 = 1,
  effectStartingValue = 0,
  precisionStartingValue = 1,
  seed = 1
)
}
\arguments{
\item{likelihoodProfiles}{List of grid likelihoods profiled with \code{Cyclops}.}

\item{chainLength}{Number of MCMC iterations.}

\item{burnIn}{Number of MCMC iterations to consider as burn in.}

\item{subSampleFrequency}{Subsample frequency for the MCMC.}

\item{effectPriorMean}{Prior mean for global parameter}

\item{effectPriorSd}{Prior standard deviation for the global parameter}

\item{nu0}{Prior "sample size" for precision
(with precision ~ gamma(nu0/2, nu0*sigma0/2))}

\item{sigma0}{Prior "variance" for precision
(with precision ~ gamma(nu0/2, nu0*sigma0/2))}

\item{effectStartingValue}{Initial value for global & local parameter}

\item{precisionStartingValue}{Initial value for the precision}

\item{seed}{Seed for the random number generator.}
}
\value{
A data frame with the point estimates and 95\% credible intervals for the
the global and local parameter, as well as the global precision.
Attributes of the data frame contain the MCMC trace for diagnostics.
}
\description{
Approximate a Bayesian posterior from a set of\code{Cyclops} likelihood profiles
under a hierarchical normal model
using the Markov chain Monte Carlo engine BEAST.
}
\examples{
#TBD

}
