% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_functions.R
\name{remove_adjacent_numbered_suffixes}
\alias{remove_adjacent_numbered_suffixes}
\title{Remove Adjacent Numbered Suffixes}
\usage{
remove_adjacent_numbered_suffixes(vec)
}
\arguments{
\item{vec}{A character vector containing strings. The strings may end with numbers.}
}
\value{
A character vector with the same elements as the input, but with adjacent
numbered suffixes removed as described.
}
\description{
This function identifies and removes adjacent numbered suffixes from a character vector.
If any strings in the vector have adjacent numerical suffixes, they are replaced with
the base string without the numerical suffix.
}
\examples{
template_fill <- c("item1", "item5", "item2", "item3", "item4", "item", "item100",
"product1", "product2", "product3", "product", "product11", "j8j", "j9j")
result <- remove_adjacent_numbered_suffixes(template_fill)
print(result)
# "item", "item", "item", "item", "item", "item", "item100", "product",
# "product", "product", "product", "product11", "j8j", "j9j"
}
