% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabolicanalysis.R
\name{summarizeResults}
\alias{summarizeResults}
\title{Obtain result tables and heatmaps that help interpreting your results.}
\usage{
summarizeResults(fadata, controlgroup = NA, parameters = FAMetA::parameters)
}
\arguments{
\item{fadata}{fadata containing synthesis, elongation and desaturation results.}

\item{controlgroup}{name of the control group to compare the results.}

\item{parameters}{parameters to be estimated for each fatty acid. It can be
modified to change them or to add new fatty acids.}
}
\value{
fadata list with a results element which contains: results data frame
(results for the main parameters for each fatty acid and sample), summary 
data frame (mean and sd by sample groups for each parameter and fatty acids 
from the results table), different heatmaps representing pool size and 
results (values represented are also saved in data frames) and tables 
summarizing all parameters values for synthesis and elongation (S16, E1, E2, 
E3, E4 and E5).
}
\description{
Obtain result tables and heatmaps that help interpreting your results.
}
\examples{
\donttest{
ssdata <- dataCorrection(ssexamplefadata, blankgroup = "Blank")
ssdata <- synthesisAnalysis(ssdata, R2Thr = 0.95, 
maxiter = 1e3, maxconvergence = 100, startpoints = 5)
ssdata <- elongationAnalysis(ssdata, R2Thr = 0.95, maxiter = 1e3,
maxconvergence=100, startpoints = 5, D2Thr = 0.1)
ssdata <- desaturationAnalysis(ssdata, SEThr = 0.05)
ssdata <- summarizeResults(ssdata, controlgroup = "Control13Cglc")
}

\dontrun{
fadata <- dataCorrection(examplefadata, blankgroup = "Blank")
fadata <- synthesisAnalysis(fadata, R2Thr = 0.95, maxiter = 1e3,
maxconvergence = 100, startpoints = 5)
fadata <- elongationAnalysis(fadata, R2Thr = 0.95, maxiter = 1e4,
maxconvergence = 100, startpoints = 5, D2Thr = 0.1)
fadata <- desaturationAnalysis(fadata, SEThr = 0.05)
fadata <- summarizeResults(fadata, controlgroup = "Control13Cglc")
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
