% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanET.R
\name{ETo_Pan}
\alias{ETo_Pan}
\title{Evapotranspiration based on Pan Evaporation Method}
\usage{
ETo_Pan(K_p, E_pan)
}
\arguments{
\item{K_p}{A numeric scalar that denotes the pan coefficient.}

\item{E_pan}{A numeric scalar that denotes the pan evaporation [mm/day].}
}
\value{
The function returns the value of the reference evapotranspiration as a numeric scalar.
}
\description{
\code{ETo_Pan} returns the value of reference evapotranspiration based on the pan evaporation method.
}
\details{
This is a function to calculate the reference evapotranspiration [mm/day] based on the pan evaporation method.
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
ETo_Pan(K_p = 0.6, E_pan = 5)

}
\seealso{
\code{\link{ETo_FPM}, \link{ETo_Hrg}}.
}
