% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Radiation.R
\name{NRad}
\alias{NRad}
\title{Net Radiation (R_n)}
\usage{
NRad(R_ns, R_nl)
}
\arguments{
\item{R_ns}{A numeric scalar that denotes net shortwave radiation [\eqn{MJ/(m^2\times day)}].}

\item{R_nl}{A numeric scalar that denotes net longwave radiation [\eqn{MJ/(m^2\times day)}].}
}
\value{
The function returns the value of net solar radiation as a numeric scalar.
}
\description{
\code{NRad} returns the value of net radiation.
}
\details{
This is a function to calculate the net radiation [\eqn{MJ/(m^2\times day)}].
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
NRad(R_ns = 11.1, R_nl = 3.5)

}
\seealso{
\code{\link{NLRad}, \link{NSRad}}.
}
