% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{density}
\alias{density}
\title{Compute Skew-t Densities from Forecasted Quantiles}
\usage{
density(
  quantiles,
  levels = c(0.05, 0.25, 0.5, 0.75, 0.95),
  est_points = 512,
  random_samples = 5000,
  seed = NULL
)
}
\arguments{
\item{quantiles}{A matrix of forecasted quantiles. Each row is a time observation; each column a quantile level.}

\item{levels}{A numeric vector of the quantile levels corresponding to the columns of the quantile matrix (default: c(0.05, 0.25, 0.50, 0.75, 0.95)).}

\item{est_points}{Integer. Number of evaluation points for the estimated density (default: 512).}

\item{random_samples}{Integer. Number of random samples to draw from the fitted skew-t distribution (default: 5000).}

\item{seed}{Optional integer to set the random seed for reproducibility (default: NULL).}
}
\value{
An object of class \code{"fars_density"}, which is a list containing the following components:
\describe{
\item{density}{A matrix of estimated densities for each time period (rows) across estimation points (columns).}
\item{distribution}{A matrix of random draws from the fitted skew-t distribution for each time period.}
\item{x_vals}{The sequence of evaluation points used to compute the density. Useful for plotting.}
}
}
\description{
Fits a skew-t distribution to a set of quantile forecasts using linear optimization
}
\examples{
\donttest{

Quantiles <- matrix(rnorm(500, mean = 0, sd = 1), nrow = 100, ncol = 5)
Levels <- c(0.05, 0.25, 0.5, 0.75, 0.95)
density_result <- density(Quantiles,
                          levels = Levels,
                          est_points = 512,
                          random_samples = 100000,
                          seed = 42)
}

}
