% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mlp_net.R
\name{mlp_net-MSE-gradients}
\alias{mlp_grad}
\alias{mlp_gradi}
\alias{mlp_gradij}
\alias{mlp_mse}
\alias{mlp_net-MSE-gradients}
\title{Computing mean squared error, its gradient, and output gradients}
\usage{
mlp_mse(net, input, output)

mlp_grad(net, input, output)

mlp_gradi(net, input, output, i)

mlp_gradij(net, input, i)
}
\arguments{
\item{net}{an object of \code{mlp_net} class}

\item{input}{numeric matrix, each row corresponds to one input vector,
number of columns must be equal to the number of neurons
in the network input layer}

\item{output}{numeric matrix with rows corresponding to expected outputs,
number of columns must be equal to the number of neurons
in the network output layer, number of rows must be equal to the number
of input rows}

\item{i}{data row index}
}
\value{
\code{mlp_mse} returns mean squared error (numeric value).

\code{mlp_grad} returns two-element lists with the first
field (\code{grad}) containing numeric vector with gradient and the second
(\code{mse}) - the mean squared error.

\code{mlp_gradi} returns numeric vector with gradient.

\code{mlp_gradij} returns numeric matrix with gradients of outputs in
consecutive columns.
}
\description{
The functions use fast FCNN kernel routines and are intended for implementing
teaching and pruning algorithms.
}
\details{
\code{mlp_mse} returns the mean squared error (MSE). MSE is understood
as half of the squared error averaged over all outputs and data records.

\code{mlp_grad} computes the gradient of MSE w.r.t. network weights.
This function is useful when implementing batch teaching algorithms.

\code{mlp_gradi} computes the gradient of MSE w.r.t. network weights at the \code{i}th
data record. This is normalised by the number of outputs only,
the average over all rows (all i) returns the same as \code{grad(input, output)}.
This function is useful when implementing on-line teaching algorithms.

\code{mlp_gradij} computes gradients of network outputs,
i.e the derivatives of outputs w.r.t. active weights, at given data row.
The derivatives of outputs are placed in subsequent columns of the returned
matrix. Scaled by the output errors and averaged they give the same
as \code{gradi(input, output, i)}. This function is useful in implementing
teaching algorithms using second order corrections and Optimal Brain Surgeon
pruning algorithm.
}

